/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtp.util;

import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import com.sun.media.JMFSecurity;
import com.sun.media.JMFSecurityManager;
import com.sun.media.rtp.util.Packet;
import com.sun.media.rtp.util.PacketConsumer;
import com.sun.media.rtp.util.UDPPacket;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketException;

public class UDPPacketSender
implements PacketConsumer {
    private DatagramSocket sock;
    private InetAddress address;
    private int port;
    private int ttl;
    private static JMFSecurity jmfSecurity = null;
    private static boolean securityPrivelege = false;
    private Method[] m = new Method[1];
    private Class[] cl = new Class[1];
    private Object[][] args = new Object[1][0];

    static {
        try {
            jmfSecurity = JMFSecurityManager.getJMFSecurity();
            securityPrivelege = true;
        }
        catch (SecurityException securityException) {}
    }

    public UDPPacketSender() throws IOException {
        this(new DatagramSocket());
    }

    public UDPPacketSender(int n2) throws IOException {
        this(new DatagramSocket(n2));
    }

    public UDPPacketSender(int n2, InetAddress inetAddress, InetAddress inetAddress2, int n3) throws IOException {
        if (inetAddress2.isMulticastAddress()) {
            MulticastSocket multicastSocket = new MulticastSocket(n2);
            if (inetAddress != null) {
                multicastSocket.setInterface(inetAddress);
            }
            this.sock = multicastSocket;
        } else if (inetAddress != null) {
            try {
                this.sock = new DatagramSocket(n2, inetAddress);
            }
            catch (SocketException socketException) {
                System.out.println(socketException);
                System.out.println("localPort: " + n2);
                System.out.println("localAddress: " + inetAddress);
                throw socketException;
            }
        } else {
            this.sock = new DatagramSocket(n2);
        }
        this.setRemoteAddress(inetAddress2, n3);
    }

    public UDPPacketSender(DatagramSocket datagramSocket) {
        this.sock = datagramSocket;
    }

    public UDPPacketSender(InetAddress inetAddress, int n2) throws IOException {
        if (inetAddress.isMulticastAddress()) {
            MulticastSocket multicastSocket = new MulticastSocket();
            this.sock = multicastSocket;
        } else {
            this.sock = new DatagramSocket();
        }
        this.setRemoteAddress(inetAddress, n2);
    }

    public void closeConsumer() {
        if (this.sock != null) {
            this.sock.close();
            this.sock = null;
        }
    }

    public String consumerString() {
        String string = "UDP Datagram Packet Sender on port " + this.sock.getLocalPort();
        if (this.address != null) {
            string = String.valueOf(string) + " sending to address " + this.address + ", port " + this.port + ", ttl" + this.ttl;
        }
        return string;
    }

    public InetAddress getLocalAddress() {
        return this.sock.getLocalAddress();
    }

    public int getLocalPort() {
        return this.sock.getLocalPort();
    }

    public DatagramSocket getSocket() {
        return this.sock;
    }

    public void send(Packet packet, InetAddress inetAddress, int n2) throws IOException {
        byte[] byArray = packet.data;
        if (packet.offset > 0) {
            byte[] byArray2 = byArray;
            byArray = new byte[packet.length];
            System.arraycopy(byArray2, packet.offset, byArray, 0, packet.length);
        }
        DatagramPacket datagramPacket = new DatagramPacket(byArray, packet.length, inetAddress, n2);
        this.sock.send(datagramPacket);
    }

    public void sendTo(Packet packet) throws IOException {
        InetAddress inetAddress = null;
        int n2 = 0;
        if (packet instanceof UDPPacket) {
            UDPPacket uDPPacket = (UDPPacket)packet;
            inetAddress = uDPPacket.remoteAddress;
            n2 = uDPPacket.remotePort;
            if (jmfSecurity != null) {
                String string = null;
                try {
                    if (jmfSecurity.getName().startsWith("jmf-security")) {
                        if (uDPPacket.remoteAddress.isMulticastAddress()) {
                            string = "multicast";
                            jmfSecurity.requestPermission(this.m, this.cl, this.args, 512);
                            this.m[0].invoke((Object)this.cl[0], this.args[0]);
                        }
                        string = "connect";
                        jmfSecurity.requestPermission(this.m, this.cl, this.args, 128);
                        this.m[0].invoke((Object)this.cl[0], this.args[0]);
                    } else if (jmfSecurity.getName().startsWith("internet")) {
                        PolicyEngine.checkPermission((PermissionID)PermissionID.NETIO);
                        PolicyEngine.assertPermission((PermissionID)PermissionID.NETIO);
                    }
                }
                catch (Throwable throwable) {
                    if (string.startsWith("multicast")) {
                        jmfSecurity.permissionFailureNotification(512);
                    }
                    jmfSecurity.permissionFailureNotification(128);
                }
            }
        }
        if (inetAddress == null) {
            throw new IllegalArgumentException("No address set");
        }
        this.send(packet, inetAddress, n2);
    }

    public void setRemoteAddress(InetAddress inetAddress, int n2) {
        this.address = inetAddress;
        this.port = n2;
    }

    public void setttl(int n2) throws IOException {
        this.ttl = n2;
        if (this.sock instanceof MulticastSocket) {
            ((MulticastSocket)this.sock).setTTL((byte)this.ttl);
        }
    }
}

