/*
 * Decompiled with CFR 0.152.
 */
package javax.media.protocol;

import java.io.IOException;
import java.io.InputStream;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.PullSourceStream;

public class InputSourceStream
implements PullSourceStream {
    protected InputStream stream;
    protected boolean eosReached;
    ContentDescriptor contentType;

    public InputSourceStream(InputStream inputStream, ContentDescriptor contentDescriptor) {
        this.stream = inputStream;
        this.eosReached = false;
        this.contentType = contentDescriptor;
    }

    public void close() throws IOException {
        this.stream.close();
    }

    public boolean endOfStream() {
        return this.eosReached;
    }

    public ContentDescriptor getContentDescriptor() {
        return this.contentType;
    }

    public long getContentLength() {
        return -1L;
    }

    public Object getControl(String string) {
        return null;
    }

    public Object[] getControls() {
        return new Object[0];
    }

    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = this.stream.read(byArray, n2, n3);
        if (n4 == -1) {
            this.eosReached = true;
        }
        return n4;
    }

    public boolean willReadBlock() {
        if (this.eosReached) {
            return true;
        }
        try {
            return this.stream.available() == 0;
        }
        catch (IOException iOException) {
            return true;
        }
    }
}

