/*
 * Decompiled with CFR 0.152.
 */
package javax.media.rtp;

import com.sun.media.Log;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Vector;
import javax.media.Controls;
import javax.media.Format;
import javax.media.PackageManager;
import javax.media.format.UnsupportedFormatException;
import javax.media.protocol.DataSource;
import javax.media.rtp.EncryptionInfo;
import javax.media.rtp.GlobalReceptionStats;
import javax.media.rtp.GlobalTransmissionStats;
import javax.media.rtp.InvalidSessionAddressException;
import javax.media.rtp.LocalParticipant;
import javax.media.rtp.RTPConnector;
import javax.media.rtp.ReceiveStreamListener;
import javax.media.rtp.RemoteListener;
import javax.media.rtp.SendStream;
import javax.media.rtp.SendStreamListener;
import javax.media.rtp.SessionAddress;
import javax.media.rtp.SessionListener;
import javax.media.rtp.rtcp.SourceDescription;

public abstract class RTPManager
implements Controls {
    private static boolean jdkInit = false;
    private static Method forName3ArgsM;
    private static Method getSystemClassLoaderM;
    private static ClassLoader systemClassLoader;
    private static Method getContextClassLoaderM;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class class$java$lang$Thread;

    public abstract void addFormat(Format var1, int var2);

    public abstract void addReceiveStreamListener(ReceiveStreamListener var1);

    public abstract void addRemoteListener(RemoteListener var1);

    public abstract void addSendStreamListener(SendStreamListener var1);

    public abstract void addSessionListener(SessionListener var1);

    public abstract void addTarget(SessionAddress var1) throws InvalidSessionAddressException, IOException;

    static Vector buildClassList(Vector vector, String string) {
        Vector<String> vector2 = new Vector<String>();
        vector2.addElement(string);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            vector2.addElement(String.valueOf(string2) + "." + string);
        }
        return vector2;
    }

    private static boolean checkIfJDK12() {
        if (jdkInit) {
            return forName3ArgsM != null;
        }
        jdkInit = true;
        try {
            forName3ArgsM = (class$java$lang$Class != null ? class$java$lang$Class : (class$java$lang$Class = RTPManager.class$("java.lang.Class"))).getMethod("forName", class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = RTPManager.class$("java.lang.String")), Boolean.TYPE, class$java$lang$ClassLoader != null ? class$java$lang$ClassLoader : (class$java$lang$ClassLoader = RTPManager.class$("java.lang.ClassLoader")));
            getSystemClassLoaderM = (class$java$lang$ClassLoader != null ? class$java$lang$ClassLoader : (class$java$lang$ClassLoader = RTPManager.class$("java.lang.ClassLoader"))).getMethod("getSystemClassLoader", null);
            systemClassLoader = (ClassLoader)getSystemClassLoaderM.invoke((Object)(class$java$lang$ClassLoader != null ? class$java$lang$ClassLoader : (class$java$lang$ClassLoader = RTPManager.class$("java.lang.ClassLoader"))), null);
            getContextClassLoaderM = (class$java$lang$Thread != null ? class$java$lang$Thread : (class$java$lang$Thread = RTPManager.class$("java.lang.Thread"))).getMethod("getContextClassLoader", null);
            return true;
        }
        catch (Throwable throwable) {
            forName3ArgsM = null;
            return false;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public abstract SendStream createSendStream(DataSource var1, int var2) throws UnsupportedFormatException, IOException;

    public abstract void dispose();

    public abstract Vector getActiveParticipants();

    public abstract Vector getAllParticipants();

    static Class getClassForName(String string) throws ClassNotFoundException {
        block9: {
            try {
                return Class.forName(string);
            }
            catch (Exception exception) {
                if (!RTPManager.checkIfJDK12()) {
                    throw new ClassNotFoundException(exception.getMessage());
                }
            }
            catch (Error error) {
                if (RTPManager.checkIfJDK12()) break block9;
                throw error;
            }
        }
        try {
            return (Class)forName3ArgsM.invoke((Object)(class$java$lang$Class != null ? class$java$lang$Class : (class$java$lang$Class = RTPManager.class$("java.lang.Class"))), string, new Boolean(true), systemClassLoader);
        }
        catch (Throwable throwable) {
            try {
                ClassLoader classLoader = (ClassLoader)getContextClassLoaderM.invoke((Object)Thread.currentThread(), null);
                return (Class)forName3ArgsM.invoke((Object)(class$java$lang$Class != null ? class$java$lang$Class : (class$java$lang$Class = RTPManager.class$("java.lang.Class"))), string, new Boolean(true), classLoader);
            }
            catch (Exception exception) {
                throw new ClassNotFoundException(exception.getMessage());
            }
            catch (Error error) {
                throw error;
            }
        }
    }

    public abstract Object getControl(String var1);

    public abstract Object[] getControls();

    public abstract GlobalReceptionStats getGlobalReceptionStats();

    public abstract GlobalTransmissionStats getGlobalTransmissionStats();

    public abstract LocalParticipant getLocalParticipant();

    public abstract Vector getPassiveParticipants();

    static Vector getProtocolPrefixList() {
        return (Vector)PackageManager.getProtocolPrefixList().clone();
    }

    public static Vector getRTPManagerList() {
        String string = "media.rtp.RTPSessionMgr";
        return RTPManager.buildClassList(RTPManager.getProtocolPrefixList(), string);
    }

    public abstract Vector getReceiveStreams();

    public abstract Vector getRemoteParticipants();

    public abstract Vector getSendStreams();

    public abstract void initialize(RTPConnector var1);

    public abstract void initialize(SessionAddress var1) throws InvalidSessionAddressException, IOException;

    public abstract void initialize(SessionAddress[] var1, SourceDescription[] var2, double var3, double var5, EncryptionInfo var7) throws InvalidSessionAddressException, IOException;

    public static RTPManager newInstance() {
        RTPManager rTPManager = null;
        Enumeration enumeration = RTPManager.getRTPManagerList().elements();
        while (enumeration.hasMoreElements()) {
            String string;
            String string2 = (String)enumeration.nextElement();
            try {
                Class clazz = RTPManager.getClassForName(string2);
                rTPManager = (RTPManager)clazz.newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (InstantiationException instantiationException) {
                string = "Error instantiating class: " + string2 + " : " + instantiationException;
                Log.error(instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                System.out.println("illegal access.");
            }
            catch (Exception exception) {
                string = "Error instantiating class: " + string2 + " : " + exception;
                Log.error(exception);
            }
            catch (Error error) {
                string = "Error instantiating class: " + string2 + " : " + error;
                Log.error(error);
            }
            if (rTPManager != null) break;
        }
        return rTPManager;
    }

    public abstract void removeReceiveStreamListener(ReceiveStreamListener var1);

    public abstract void removeRemoteListener(RemoteListener var1);

    public abstract void removeSendStreamListener(SendStreamListener var1);

    public abstract void removeSessionListener(SessionListener var1);

    public abstract void removeTarget(SessionAddress var1, String var2) throws InvalidSessionAddressException;

    public abstract void removeTargets(String var1);
}

