/*
 * Decompiled with CFR 0.152.
 */
package jmapps.registry;

import com.sun.media.MimeManager;
import com.sun.media.util.JMFI18N;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jmapps.ui.JMPanel;
import jmapps.ui.MessageDialog;

public class MimePanel
extends JMPanel
implements ActionListener,
ItemListener,
TextListener {
    private Hashtable htMimeTypes;
    private Button buttonRestore;
    private Button buttonCommit;
    private Button buttonAdd;
    private Button buttonRemove;
    private List listBoxMimeType;
    private TextField textMimeType;
    private List listBoxMimeExt;
    private TextField textMimeExt;

    public MimePanel() {
        this.init();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        String string = actionEvent.getActionCommand();
        if (string.equals(this.buttonRestore.getActionCommand())) {
            this.restore();
        }
        if (string.equals(this.buttonCommit.getActionCommand())) {
            MimeManager.commit();
        } else if (object == this.buttonAdd) {
            this.addExt();
        } else if (object == this.buttonRemove) {
            this.removeExt();
        }
        this.updateButtons();
    }

    private void addExt() {
        boolean bl = true;
        String string = this.textMimeExt.getText().trim();
        if (string.length() < 1) {
            return;
        }
        String string2 = this.textMimeType.getText().trim();
        if (string2.length() < 1) {
            return;
        }
        if (!this.htMimeTypes.containsKey(string2)) {
            this.addType();
        }
        if (!this.htMimeTypes.containsKey(string2)) {
            return;
        }
        Vector vector = (Vector)this.htMimeTypes.get(string2);
        if (!vector.contains(string)) {
            bl = MimeManager.addMimeType(string, string2);
            if (bl) {
                vector.addElement(string);
                this.listBoxMimeExt.add(string);
            } else {
                MessageDialog.createErrorDialog(new Frame(), JMFI18N.getResource("jmfregistry.appname"), JMFI18N.getResource("jmfregistry.error.additem"));
            }
        }
        if (bl) {
            this.selectItem(this.listBoxMimeExt, string);
        }
    }

    private void addType() {
        String string = this.textMimeType.getText().trim();
        if (string.length() < 1) {
            return;
        }
        if (!this.htMimeTypes.containsKey(string)) {
            Vector vector = new Vector();
            this.htMimeTypes.put(string, vector);
            this.listBoxMimeType.add(string);
        }
        this.selectItem(this.listBoxMimeType, string);
        this.fillExtList();
    }

    private Panel createPanelButtons() {
        Panel panel = new Panel(new FlowLayout(0));
        Panel panel2 = new Panel(new GridLayout(0, 1, 12, 12));
        panel.add(panel2);
        this.buttonAdd = new Button(JMFI18N.getResource("jmfregistry.vector.add"));
        this.buttonAdd.addActionListener(this);
        panel2.add(this.buttonAdd);
        this.buttonRemove = new Button(JMFI18N.getResource("jmfregistry.vector.remove"));
        this.buttonRemove.addActionListener(this);
        panel2.add(this.buttonRemove);
        this.buttonRestore = new Button(JMFI18N.getResource("jmfregistry.vector.restore"));
        this.buttonRestore.addActionListener(this);
        this.buttonCommit = new Button(JMFI18N.getResource("jmfregistry.vector.commit"));
        this.buttonCommit.addActionListener(this);
        panel2.add(this.buttonCommit);
        return panel;
    }

    private Panel createPanelMimeExt() {
        Panel panel = new Panel(new BorderLayout(6, 6));
        Panel panel2 = new Panel(new BorderLayout(6, 6));
        panel.add((Component)panel2, "North");
        Label label = new Label(JMFI18N.getResource("jmfregistry.mime.ext.label"));
        panel2.add((Component)label, "North");
        this.textMimeExt = new TextField();
        this.textMimeExt.addTextListener(this);
        panel2.add((Component)this.textMimeExt, "Center");
        this.listBoxMimeExt = new List();
        this.listBoxMimeExt.addItemListener(this);
        panel.add((Component)this.listBoxMimeExt, "Center");
        return panel;
    }

    private Panel createPanelMimeTypes() {
        Panel panel = new Panel(new BorderLayout(6, 6));
        Panel panel2 = new Panel(new BorderLayout(6, 6));
        panel.add((Component)panel2, "North");
        Label label = new Label(JMFI18N.getResource("jmfregistry.mime.type.label"));
        panel2.add((Component)label, "North");
        this.textMimeType = new TextField();
        this.textMimeType.addTextListener(this);
        panel2.add((Component)this.textMimeType, "Center");
        this.listBoxMimeType = new List();
        this.listBoxMimeType.addItemListener(this);
        panel.add((Component)this.listBoxMimeType, "Center");
        return panel;
    }

    private void fillExtList() {
        this.listBoxMimeExt.removeAll();
        String string = this.listBoxMimeType.getSelectedItem();
        if (string == null) {
            return;
        }
        Vector vector = (Vector)this.htMimeTypes.get(string);
        int n2 = vector.size();
        int n3 = 0;
        while (n3 < n2) {
            Object e2 = vector.elementAt(n3);
            this.listBoxMimeExt.add(e2.toString());
            ++n3;
        }
    }

    private void fillTypeList() {
        this.listBoxMimeType.removeAll();
        Enumeration enumeration = this.htMimeTypes.keys();
        while (enumeration.hasMoreElements()) {
            Object k2 = enumeration.nextElement();
            this.listBoxMimeType.add(k2.toString());
        }
    }

    private int getItemIndex(List list, String string) {
        int n2 = list.getItemCount();
        int n3 = 0;
        while (n3 < n2) {
            String string2 = list.getItem(n3);
            if (string2.equals(string)) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    private void init() {
        this.setLayout(new BorderLayout(6, 6));
        Panel panel = this.createPanelButtons();
        this.add((Component)panel, "East");
        Panel panel2 = new Panel(new GridLayout(1, 0, 12, 12));
        this.add((Component)panel2, "Center");
        panel = this.createPanelMimeTypes();
        panel2.add(panel);
        panel = this.createPanelMimeExt();
        panel2.add(panel);
        this.restore();
        this.updateButtons();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.listBoxMimeType) {
            String string = this.listBoxMimeType.getSelectedItem();
            this.textMimeType.setText(string);
            this.fillExtList();
        } else if (object == this.listBoxMimeExt) {
            String string = this.listBoxMimeExt.getSelectedItem();
            this.textMimeExt.setText(string);
        }
        this.updateButtons();
    }

    private void removeExt() {
        boolean bl = true;
        String string = this.textMimeExt.getText().trim();
        if (string.length() < 1) {
            return;
        }
        String string2 = this.textMimeType.getText().trim();
        if (string2.length() < 1) {
            return;
        }
        if (!this.htMimeTypes.containsKey(string2)) {
            return;
        }
        Vector vector = (Vector)this.htMimeTypes.get(string2);
        if (!vector.contains(string)) {
            return;
        }
        bl = MimeManager.removeMimeType(string);
        if (bl) {
            vector.removeElement(string);
            int n2 = this.getItemIndex(this.listBoxMimeExt, string);
            this.listBoxMimeExt.remove(string);
            if (vector.isEmpty()) {
                this.removeType();
            }
        } else {
            MessageDialog.createErrorDialog(new Frame(), JMFI18N.getResource("jmfregistry.appname"), JMFI18N.getResource("jmfregistry.error.removeitem"));
        }
    }

    private void removeType() {
        boolean bl = true;
        String string = this.textMimeType.getText().trim();
        if (string.length() < 1) {
            return;
        }
        Vector vector = (Vector)this.htMimeTypes.get(string);
        int n2 = vector.size();
        int n3 = n2 - 1;
        while (n3 >= 0) {
            String string2 = (String)vector.elementAt(n3);
            bl = MimeManager.removeMimeType(string2);
            if (bl) {
                vector.removeElement(string2);
                this.listBoxMimeExt.remove(string2);
            }
            --n3;
        }
        n2 = vector.size();
        if (n2 > 0) {
            this.listBoxMimeExt.select(0);
            MessageDialog.createErrorDialog(new Frame(), JMFI18N.getResource("jmfregistry.appname"), JMFI18N.getResource("jmfregistry.error.removeitem"));
        } else {
            this.htMimeTypes.remove(string);
            n3 = this.getItemIndex(this.listBoxMimeType, string);
            this.listBoxMimeType.remove(string);
        }
    }

    private void restore() {
        Hashtable hashtable = MimeManager.getMimeTable();
        this.htMimeTypes = new Hashtable();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Vector vector;
            Object k2 = enumeration.nextElement();
            Object v = hashtable.get(k2);
            String string = k2.toString();
            String string2 = v.toString();
            if (this.htMimeTypes.containsKey(string2)) {
                vector = (Vector)this.htMimeTypes.get(string2);
            } else {
                vector = new Vector();
                this.htMimeTypes.put(string2, vector);
            }
            if (vector.contains(string)) continue;
            vector.addElement(string);
        }
        this.fillTypeList();
    }

    private void selectItem(List list, String string) {
        int n2 = this.getItemIndex(list, string);
        if (n2 >= 0) {
            list.select(n2);
        }
    }

    public void textValueChanged(TextEvent textEvent) {
        this.updateButtons();
    }

    private void updateButtons() {
        boolean bl;
        boolean bl2;
        String string = this.textMimeExt.getText().trim();
        String string2 = this.textMimeType.getText().trim();
        if (string.length() > 1 && string2.length() > 1) {
            bl2 = true;
            bl = true;
        } else {
            bl2 = false;
            bl = false;
        }
        if (this.htMimeTypes.containsKey(string2)) {
            Vector vector = (Vector)this.htMimeTypes.get(string2);
            if (vector.contains(string)) {
                bl2 = false;
            } else {
                bl = false;
            }
        } else {
            bl = false;
        }
        this.buttonAdd.setEnabled(bl2);
        this.buttonRemove.setEnabled(bl);
    }
}

