/*
 * Decompiled with CFR 0.152.
 */
package jmapps.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Window;
import jmapps.ui.ImageArea;
import jmapps.ui.JMPanel;
import jmapps.ui.TextView;

public class PopupWait
extends Window {
    private JMPanel panelOuter;
    private JMPanel panelInner;
    private JMPanel panelImage;
    private ImageArea fieldImage;
    private TextView fieldText;
    private Frame frameOwner;
    private String strText;
    private UpdateThread threadUpdate = new UpdateThread();
    private Cursor cursorOld;
    private Cursor cursorWait = new Cursor(3);
    private Cursor cursorOldOwner;
    private Cursor cursorWaitOwner = new Cursor(3);

    public PopupWait(Frame frame, String string) {
        super(frame);
        this.frameOwner = frame;
        this.strText = string;
        try {
            this.init();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void init() throws Exception {
        this.setLayout(new BorderLayout(6, 6));
        this.panelOuter = new JMPanel(new BorderLayout(6, 6));
        this.panelOuter.setBackground(Color.lightGray);
        this.panelOuter.setRaisedBorder();
        this.add((Component)this.panelOuter, "Center");
        this.panelInner = new JMPanel(new BorderLayout(6, 6));
        this.panelInner.setEmptyBorder(6, 6, 6, 6);
        this.panelOuter.add((Component)this.panelInner, "Center");
        this.panelImage = new JMPanel(new FlowLayout());
        this.panelInner.add((Component)this.panelImage, "West");
        Image image = ImageArea.loadImage("logo.gif", this, true);
        this.fieldImage = new ImageArea(image);
        this.fieldImage.setInsets(0, 0, 0, 0);
        this.panelImage.add(this.fieldImage);
        this.fieldText = new TextView(this.strText);
        this.fieldText.setPreferredWidth(256);
        this.panelInner.add((Component)this.fieldText, "Center");
        this.pack();
        Dimension dimension = this.getSize();
        Dimension dimension2 = this.getToolkit().getScreenSize();
        Point point = new Point((dimension2.width - dimension.width) / 2, (dimension2.height - dimension.height) / 2);
        ((Component)this).setLocation(point);
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.cursorOld = this.getCursor();
            this.setCursor(this.cursorWait);
            this.cursorOldOwner = this.frameOwner.getCursor();
            this.frameOwner.setCursor(this.cursorWaitOwner);
            this.threadUpdate.start();
        } else {
            this.threadUpdate.terminateThread();
            this.setCursor(this.cursorOld);
            this.frameOwner.setCursor(this.cursorOldOwner);
        }
    }

    private class UpdateThread
    extends Thread {
        private boolean boolTerminate = false;

        public void run() {
            this.boolTerminate = false;
            while (!this.boolTerminate) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {}
                this.updateComponent(PopupWait.this.panelOuter);
                this.updateComponent(PopupWait.this.panelInner);
                this.updateComponent(PopupWait.this.panelImage);
                this.updateComponent(PopupWait.this.fieldImage);
                this.updateComponent(PopupWait.this.fieldText);
            }
        }

        public void terminateThread() {
            this.boolTerminate = true;
        }

        private void updateComponent(Component component) {
            if (component == null) {
                return;
            }
            if (!component.isShowing()) {
                return;
            }
            Graphics graphics = component.getGraphics();
            if (graphics == null) {
                return;
            }
            component.update(graphics);
        }
    }
}

