/*
 * Decompiled with CFR 0.152.
 */
package guk.im;

import guk.im.GateIM;
import guk.im.Key;
import guk.im.LocaleHandler;
import guk.im.State;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;

public class KeyboardMap
implements Runnable {
    LocaleHandler handler;
    LocaleHandler newHandler;
    State state;
    State newState;
    Window window;
    JPanel contentPane;
    List highlightedKeys = new ArrayList();
    boolean shift = false;
    boolean ctrl = false;
    boolean alt = false;
    boolean capslock = false;
    Map GUIforString;
    Map labelForKey;
    GateIM im;
    Thread myThread;
    List jobs;
    static Component placeHolder = Box.createRigidArea(new Dimension(12, 12));

    public KeyboardMap(GateIM gateIM, LocaleHandler localeHandler, State state) {
        this.im = gateIM;
        this.handler = localeHandler;
        this.state = state;
        this.jobs = Collections.synchronizedList(new ArrayList());
        this.myThread = new Thread(this);
        this.myThread.start();
    }

    public void run() {
        KeyGUI keyGUI;
        String string;
        Key key;
        this.window = this.im.getContext().createInputMethodWindow(null, true);
        if (this.window instanceof Frame) {
            ((Frame)this.window).setTitle(this.handler.locale.getDisplayName() + " keyboard map");
        }
        ((Component)this.window).setVisible(false);
        this.window.addWindowListener(new WindowAdapter(){});
        this.window.setLayout(new GridLayout(1, 1));
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.contentPane = new JPanel(gridBagLayout);
        this.contentPane.setDoubleBuffered(true);
        this.window.add((Component)this.contentPane, "Center");
        this.labelForKey = new HashMap();
        this.GUIforString = new HashMap();
        double[] dArray = new double[45];
        int n = 0;
        while (n < dArray.length) {
            dArray[n] = 0.001;
            ++n;
        }
        gridBagLayout.columnWeights = dArray;
        dArray = new double[5];
        int n2 = 0;
        while (n2 < dArray.length) {
            dArray[n2] = 0.001;
            ++n2;
        }
        gridBagLayout.rowWeights = dArray;
        Map map = this.handler.getKeyCap();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            key = (Key)iterator.next();
            JLabel jLabel = new JLabel();
            jLabel.setFont(GateIM.getKeyboardFont());
            jLabel.setForeground(Color.black);
            jLabel.setText((String)map.get(key));
            this.labelForKey.put(key, jLabel);
        }
        this.GUIforString = new HashMap();
        int n3 = 0;
        if (this.ctrl) {
            n3 |= 2;
        }
        if (this.alt) {
            n3 |= 8;
        }
        char c = 'a';
        while (c <= 'z') {
            string = "" + c;
            key = this.shift ? new Key(Character.toUpperCase(c), n3) : new Key(c, n3);
            keyGUI = new KeyGUI(string, c, Character.toUpperCase(c), (JLabel)this.labelForKey.get(key));
            this.GUIforString.put(string, keyGUI);
            c = (char)(c + 1);
        }
        c = this.shift ? (char)'!' : '1';
        string = "1";
        key = new Key(c, n3);
        keyGUI = new KeyGUI(string, '1', '!', (JLabel)this.labelForKey.get(key));
        this.GUIforString.put(string, keyGUI);
        c = this.shift ? (char)'\"' : '2';
        string = "2";
        key = new Key(c, n3);
        keyGUI = new KeyGUI(string, '2', '\"', (JLabel)this.labelForKey.get(key));
        this.GUIforString.put(string, keyGUI);
        c = this.shift ? (char)'\u00a3' : '3';
        string = "3";
        key = new Key(c, n3);
        keyGUI = new KeyGUI(string, '3', '\u00a3', (JLabel)this.labelForKey.get(key));
        this.GUIforString.put(string, keyGUI);
        c = this.shift ? (char)'$' : '4';
        string = "4";
        key = new Key(c, n3);
        keyGUI = new KeyGUI(string, '4', '$', (JLabel)this.labelForKey.get(key));
        this.GUIforString.put(string, keyGUI);
        c = this.shift ? (char)'%' : '5';
        string = "5";
        key = new Key(c, n3);
        keyGUI = new KeyGUI(string, '5', '%', (JLabel)this.labelForKey.get(key));
        this.GUIforString.put(string, keyGUI);
        c = this.shift ? (char)'^' : '6';
        string = "6";
        key = new Key(c, n3);
        keyGUI = new KeyGUI(string, '6', '^', (JLabel)this.labelForKey.get(key));
        this.GUIforString.put(string, keyGUI);
        c = this.shift ? (char)'&' : '7';
        string = "7";
        key = new Key(c, n3);
        keyGUI = new KeyGUI(string, '7', '&', (JLabel)this.labelForKey.get(key));
        this.GUIforString.put(string, keyGUI);
        c = this.shift ? (char)'*' : '8';
        string = "8";
        key = new Key(c, n3);
        keyGUI = new KeyGUI(string, '8', '*', (JLabel)this.labelForKey.get(key));
        this.GUIforString.put(string, keyGUI);
        c = this.shift ? (char)'(' : '9';
        string = "9";
        key = new Key(c, n3);
        keyGUI = new KeyGUI(string, '9', '(', (JLabel)this.labelForKey.get(key));
        this.GUIforString.put(string, keyGUI);
        c = this.shift ? (char)')' : '0';
        string = "0";
        key = new Key(c, n3);
        keyGUI = new KeyGUI(string, '0', ')', (JLabel)this.labelForKey.get(key));
        this.GUIforString.put(string, keyGUI);
        c = this.shift ? (char)'\u00ac' : '`';
        string = "`";
        key = new Key(c, n3);
        keyGUI = new KeyGUI(string, '`', '\u00ac', (JLabel)this.labelForKey.get(key));
        this.GUIforString.put(string, keyGUI);
        c = this.shift ? (char)'_' : '-';
        string = "-";
        key = new Key(c, n3);
        keyGUI = new KeyGUI(string, '-', '_', (JLabel)this.labelForKey.get(key));
        this.GUIforString.put(string, keyGUI);
        c = this.shift ? (char)'+' : '=';
        string = "=";
        key = new Key(c, n3);
        keyGUI = new KeyGUI(string, '=', '+', (JLabel)this.labelForKey.get(key));
        this.GUIforString.put(string, keyGUI);
        c = this.shift ? (char)'{' : '[';
        string = "[";
        key = new Key(c, n3);
        keyGUI = new KeyGUI(string, '[', '{', (JLabel)this.labelForKey.get(key));
        this.GUIforString.put(string, keyGUI);
        c = this.shift ? (char)'}' : ']';
        string = "]";
        key = new Key(c, n3);
        keyGUI = new KeyGUI(string, ']', '}', (JLabel)this.labelForKey.get(key));
        this.GUIforString.put(string, keyGUI);
        c = this.shift ? (char)':' : ';';
        string = ";";
        key = new Key(c, n3);
        keyGUI = new KeyGUI(string, ';', ':', (JLabel)this.labelForKey.get(key));
        this.GUIforString.put(string, keyGUI);
        c = this.shift ? (char)'@' : '\'';
        string = "'";
        key = new Key(c, n3);
        keyGUI = new KeyGUI(string, '\'', '@', (JLabel)this.labelForKey.get(key));
        this.GUIforString.put(string, keyGUI);
        c = this.shift ? (char)'~' : '#';
        string = "#";
        key = new Key(c, n3);
        keyGUI = new KeyGUI(string, '#', '~', (JLabel)this.labelForKey.get(key));
        this.GUIforString.put(string, keyGUI);
        c = this.shift ? (char)'|' : '\\';
        string = "\\";
        key = new Key(c, n3);
        keyGUI = new KeyGUI(string, '\\', '|', (JLabel)this.labelForKey.get(key));
        this.GUIforString.put(string, keyGUI);
        c = this.shift ? (char)'<' : ',';
        string = ",";
        key = new Key(c, n3);
        keyGUI = new KeyGUI(string, ',', '<', (JLabel)this.labelForKey.get(key));
        this.GUIforString.put(string, keyGUI);
        c = this.shift ? (char)'>' : '.';
        string = ".";
        key = new Key(c, n3);
        keyGUI = new KeyGUI(string, '.', '>', (JLabel)this.labelForKey.get(key));
        this.GUIforString.put(string, keyGUI);
        c = this.shift ? (char)'?' : '/';
        string = "/";
        key = new Key(c, n3);
        keyGUI = new KeyGUI(string, '/', '?', (JLabel)this.labelForKey.get(key));
        this.GUIforString.put(string, keyGUI);
        this.GUIforString.put("BACK_SPACE", new KeyGUI("BACK_SPACE", '\u0000', '\u0000', new JLabel("BackSpace")));
        this.GUIforString.put("TAB", new KeyGUI("TAB", '\u0000', '\u0000', new JLabel("Tab")));
        this.GUIforString.put("CAPS_LOCK", new KeyGUI("CAPS_LOCK", '\u0000', '\u0000', new JLabel("Caps Lock")));
        this.GUIforString.put("ENTER", new KeyGUI("ENTER", '\u0000', '\u0000', new JLabel("Enter")));
        this.GUIforString.put("LSHIFT", new KeyGUI("LSHIFT", '\u0000', '\u0000', new JLabel("Shift")));
        this.GUIforString.put("RSHIFT", new KeyGUI("RSHIFT", '\u0000', '\u0000', new JLabel("Shift")));
        this.GUIforString.put("LCTRL", new KeyGUI("LCTRL", '\u0000', '\u0000', new JLabel("Ctrl")));
        this.GUIforString.put("RCTRL", new KeyGUI("RCTRL", '\u0000', '\u0000', new JLabel("Ctrl")));
        this.GUIforString.put("LALT", new KeyGUI("LALT", '\u0000', '\u0000', new JLabel("Alt")));
        this.GUIforString.put("RALT", new KeyGUI("RALT", '\u0000', '\u0000', new JLabel("Alt")));
        this.GUIforString.put("SPACE", new KeyGUI("SPACE", ' ', ' ', new JLabel(" ")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 3;
        this.contentPane.add((Component)this.GUIforString.get("`"), gridBagConstraints);
        this.contentPane.add((Component)this.GUIforString.get("1"), gridBagConstraints);
        this.contentPane.add((Component)this.GUIforString.get("2"), gridBagConstraints);
        this.contentPane.add((Component)this.GUIforString.get("3"), gridBagConstraints);
        this.contentPane.add((Component)this.GUIforString.get("4"), gridBagConstraints);
        this.contentPane.add((Component)this.GUIforString.get("5"), gridBagConstraints);
        this.contentPane.add((Component)this.GUIforString.get("6"), gridBagConstraints);
        this.contentPane.add((Component)this.GUIforString.get("7"), gridBagConstraints);
        this.contentPane.add((Component)this.GUIforString.get("8"), gridBagConstraints);
        this.contentPane.add((Component)this.GUIforString.get("9"), gridBagConstraints);
        this.contentPane.add((Component)this.GUIforString.get("0"), gridBagConstraints);
        this.contentPane.add((Component)this.GUIforString.get("-"), gridBagConstraints);
        this.contentPane.add((Component)this.GUIforString.get("="), gridBagConstraints);
        gridBagConstraints.gridwidth = 6;
        this.contentPane.add((Component)this.GUIforString.get("BACK_SPACE"), gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 5;
        this.contentPane.add((Component)this.GUIforString.get("TAB"), gridBagConstraints);
        gridBagConstraints.gridwidth = 3;
        this.contentPane.add((Component)this.GUIforString.get("q"), gridBagConstraints);
        this.contentPane.add((Component)this.GUIforString.get("w"), gridBagConstraints);
        this.contentPane.add((Component)this.GUIforString.get("e"), gridBagConstraints);
        this.contentPane.add((Component)this.GUIforString.get("r"), gridBagConstraints);
        this.contentPane.add((Component)this.GUIforString.get("t"), gridBagConstraints);
        this.contentPane.add((Component)this.GUIforString.get("y"), gridBagConstraints);
        this.contentPane.add((Component)this.GUIforString.get("u"), gridBagConstraints);
        this.contentPane.add((Component)this.GUIforString.get("i"), gridBagConstraints);
        this.contentPane.add((Component)this.GUIforString.get("o"), gridBagConstraints);
        this.contentPane.add((Component)this.GUIforString.get("p"), gridBagConstraints);
        this.contentPane.add((Component)this.GUIforString.get("["), gridBagConstraints);
        this.contentPane.add((Component)this.GUIforString.get("]"), gridBagConstraints);
        gridBagConstraints.gridwidth = 4;
        this.contentPane.add((Component)this.GUIforString.get("\\"), gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 6;
        this.contentPane.add((Component)this.GUIforString.get("CAPS_LOCK"), gridBagConstraints);
        gridBagConstraints.gridwidth = 3;
        this.contentPane.add((Component)this.GUIforString.get("a"), gridBagConstraints);
        this.contentPane.add((Component)this.GUIforString.get("s"), gridBagConstraints);
        this.contentPane.add((Component)this.GUIforString.get("d"), gridBagConstraints);
        this.contentPane.add((Component)this.GUIforString.get("f"), gridBagConstraints);
        this.contentPane.add((Component)this.GUIforString.get("g"), gridBagConstraints);
        this.contentPane.add((Component)this.GUIforString.get("h"), gridBagConstraints);
        this.contentPane.add((Component)this.GUIforString.get("j"), gridBagConstraints);
        this.contentPane.add((Component)this.GUIforString.get("k"), gridBagConstraints);
        this.contentPane.add((Component)this.GUIforString.get("l"), gridBagConstraints);
        this.contentPane.add((Component)this.GUIforString.get(";"), gridBagConstraints);
        this.contentPane.add((Component)this.GUIforString.get("'"), gridBagConstraints);
        gridBagConstraints.gridwidth = 6;
        this.contentPane.add((Component)this.GUIforString.get("ENTER"), gridBagConstraints);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 5;
        this.contentPane.add((Component)this.GUIforString.get("LSHIFT"), gridBagConstraints);
        gridBagConstraints.gridwidth = 3;
        this.contentPane.add((Component)this.GUIforString.get("z"), gridBagConstraints);
        this.contentPane.add((Component)this.GUIforString.get("x"), gridBagConstraints);
        this.contentPane.add((Component)this.GUIforString.get("c"), gridBagConstraints);
        this.contentPane.add((Component)this.GUIforString.get("v"), gridBagConstraints);
        this.contentPane.add((Component)this.GUIforString.get("b"), gridBagConstraints);
        this.contentPane.add((Component)this.GUIforString.get("n"), gridBagConstraints);
        this.contentPane.add((Component)this.GUIforString.get("m"), gridBagConstraints);
        this.contentPane.add((Component)this.GUIforString.get(","), gridBagConstraints);
        this.contentPane.add((Component)this.GUIforString.get("."), gridBagConstraints);
        this.contentPane.add((Component)this.GUIforString.get("/"), gridBagConstraints);
        this.contentPane.add((Component)this.GUIforString.get("#"), gridBagConstraints);
        gridBagConstraints.gridwidth = 8;
        this.contentPane.add((Component)this.GUIforString.get("RSHIFT"), gridBagConstraints);
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 5;
        this.contentPane.add((Component)this.GUIforString.get("LCTRL"), gridBagConstraints);
        this.contentPane.add((Component)this.GUIforString.get("LALT"), gridBagConstraints);
        gridBagConstraints.gridwidth = 25;
        this.contentPane.add((Component)this.GUIforString.get("SPACE"), gridBagConstraints);
        gridBagConstraints.gridwidth = 5;
        this.contentPane.add((Component)this.GUIforString.get("RALT"), gridBagConstraints);
        this.contentPane.add((Component)this.GUIforString.get("RCTRL"), gridBagConstraints);
        this.window.pack();
        if (this.im.mapVisible) {
            ((Component)this.window).setVisible(true);
        }
        block123: while (true) {
            List list = this.jobs;
            synchronized (list) {
                try {
                    if (!this.jobs.isEmpty()) {
                        block124: while (!this.jobs.isEmpty()) {
                            char c2;
                            String string2;
                            KeyGUI keyGUI2;
                            Object e = this.jobs.remove(0);
                            if (e instanceof String) {
                                String string3 = (String)e;
                                if (string3.equalsIgnoreCase("DIE")) {
                                    break block123;
                                }
                                if (string3.equalsIgnoreCase("HIDE") && this.window.isShowing()) {
                                    ((Component)this.window).setVisible(false);
                                    continue;
                                }
                                if (string3.equalsIgnoreCase("SHOW") && !this.window.isShowing()) {
                                    ((Component)this.window).setVisible(true);
                                    continue;
                                }
                                if (!string3.equalsIgnoreCase("UPDATE")) continue;
                                this.update();
                                continue;
                            }
                            if (!(e instanceof KeyEvent)) continue;
                            KeyEvent keyEvent = (KeyEvent)e;
                            if (keyEvent.getID() == 401) {
                                int n4 = keyEvent.getKeyCode();
                                switch (n4) {
                                    case 16: {
                                        if (this.shift) continue block124;
                                        this.shift = true;
                                        ((KeyGUI)this.GUIforString.get("LSHIFT")).pressKey();
                                        ((KeyGUI)this.GUIforString.get("RSHIFT")).pressKey();
                                        this.updateLabels();
                                        break;
                                    }
                                    case 17: {
                                        if (this.ctrl) continue block124;
                                        this.ctrl = true;
                                        ((KeyGUI)this.GUIforString.get("LCTRL")).pressKey();
                                        ((KeyGUI)this.GUIforString.get("RCTRL")).pressKey();
                                        this.updateLabels();
                                        break;
                                    }
                                    case 18: {
                                        if (this.alt) continue block124;
                                        this.alt = true;
                                        ((KeyGUI)this.GUIforString.get("LALT")).pressKey();
                                        ((KeyGUI)this.GUIforString.get("RALT")).pressKey();
                                        this.updateLabels();
                                        break;
                                    }
                                    case 20: {
                                        keyGUI2 = (KeyGUI)this.GUIforString.get("CAPS_LOCK");
                                        keyGUI2.pressKey();
                                        break;
                                    }
                                    case 8: {
                                        keyGUI2 = (KeyGUI)this.GUIforString.get("BACK_SPACE");
                                        keyGUI2.pressKey();
                                        break;
                                    }
                                    case 10: {
                                        keyGUI2 = (KeyGUI)this.GUIforString.get("ENTER");
                                        keyGUI2.pressKey();
                                        break;
                                    }
                                    case 9: {
                                        keyGUI2 = (KeyGUI)this.GUIforString.get("TAB");
                                        keyGUI2.pressKey();
                                        break;
                                    }
                                    case 32: {
                                        keyGUI2 = (KeyGUI)this.GUIforString.get("SPACE");
                                        keyGUI2.pressKey();
                                        break;
                                    }
                                    default: {
                                        string2 = "";
                                        c2 = keyEvent.getKeyChar();
                                        if ('a' <= c2 && c2 <= 'z') {
                                            string2 = string2 + c2;
                                        } else if ('A' <= c2 && c2 <= 'Z') {
                                            string2 = string2 + Character.toLowerCase(c2);
                                        } else {
                                            switch (c2) {
                                                case '`': {
                                                    string2 = string2 + c2;
                                                    break;
                                                }
                                                case '1': {
                                                    string2 = string2 + c2;
                                                    break;
                                                }
                                                case '2': {
                                                    string2 = string2 + c2;
                                                    break;
                                                }
                                                case '3': {
                                                    string2 = string2 + c2;
                                                    break;
                                                }
                                                case '4': {
                                                    string2 = string2 + c2;
                                                    break;
                                                }
                                                case '5': {
                                                    string2 = string2 + c2;
                                                    break;
                                                }
                                                case '6': {
                                                    string2 = string2 + c2;
                                                    break;
                                                }
                                                case '7': {
                                                    string2 = string2 + c2;
                                                    break;
                                                }
                                                case '8': {
                                                    string2 = string2 + c2;
                                                    break;
                                                }
                                                case '9': {
                                                    string2 = string2 + c2;
                                                    break;
                                                }
                                                case '0': {
                                                    string2 = string2 + c2;
                                                    break;
                                                }
                                                case '-': {
                                                    string2 = string2 + c2;
                                                    break;
                                                }
                                                case '=': {
                                                    string2 = string2 + c2;
                                                    break;
                                                }
                                                case '[': {
                                                    string2 = string2 + c2;
                                                    break;
                                                }
                                                case ']': {
                                                    string2 = string2 + c2;
                                                    break;
                                                }
                                                case ';': {
                                                    string2 = string2 + c2;
                                                    break;
                                                }
                                                case '\'': {
                                                    string2 = string2 + c2;
                                                    break;
                                                }
                                                case '#': {
                                                    string2 = string2 + c2;
                                                    break;
                                                }
                                                case '\\': {
                                                    string2 = string2 + c2;
                                                    break;
                                                }
                                                case ',': {
                                                    string2 = string2 + c2;
                                                    break;
                                                }
                                                case '.': {
                                                    string2 = string2 + c2;
                                                    break;
                                                }
                                                case '/': {
                                                    string2 = string2 + c2;
                                                    break;
                                                }
                                                case '\u00ac': {
                                                    string2 = string2 + '`';
                                                    break;
                                                }
                                                case '!': {
                                                    string2 = string2 + '1';
                                                    break;
                                                }
                                                case '\"': {
                                                    string2 = string2 + '2';
                                                    break;
                                                }
                                                case '\u00a3': {
                                                    string2 = string2 + '3';
                                                    break;
                                                }
                                                case '$': {
                                                    string2 = string2 + '4';
                                                    break;
                                                }
                                                case '%': {
                                                    string2 = string2 + '5';
                                                    break;
                                                }
                                                case '^': {
                                                    string2 = string2 + '6';
                                                    break;
                                                }
                                                case '&': {
                                                    string2 = string2 + '7';
                                                    break;
                                                }
                                                case '*': {
                                                    string2 = string2 + '8';
                                                    break;
                                                }
                                                case '(': {
                                                    string2 = string2 + '9';
                                                    break;
                                                }
                                                case ')': {
                                                    string2 = string2 + '0';
                                                    break;
                                                }
                                                case '_': {
                                                    string2 = string2 + '-';
                                                    break;
                                                }
                                                case '+': {
                                                    string2 = string2 + '=';
                                                    break;
                                                }
                                                case '{': {
                                                    string2 = string2 + '[';
                                                    break;
                                                }
                                                case '}': {
                                                    string2 = string2 + ']';
                                                    break;
                                                }
                                                case ':': {
                                                    string2 = string2 + ';';
                                                    break;
                                                }
                                                case '@': {
                                                    string2 = string2 + '\'';
                                                    break;
                                                }
                                                case '~': {
                                                    string2 = string2 + '#';
                                                    break;
                                                }
                                                case '|': {
                                                    string2 = string2 + '\\';
                                                    break;
                                                }
                                                case '<': {
                                                    string2 = string2 + ',';
                                                    break;
                                                }
                                                case '>': {
                                                    string2 = string2 + '.';
                                                    break;
                                                }
                                                case '?': {
                                                    string2 = string2 + '/';
                                                }
                                            }
                                        }
                                        keyGUI2 = (KeyGUI)this.GUIforString.get(string2);
                                        if (keyGUI2 == null) continue block124;
                                        keyGUI2.pressKey();
                                        break;
                                    }
                                }
                                continue;
                            }
                            if (keyEvent.getID() != 402) continue;
                            int n5 = keyEvent.getKeyCode();
                            switch (n5) {
                                case 16: {
                                    if (!this.shift) continue block124;
                                    this.shift = false;
                                    ((KeyGUI)this.GUIforString.get("LSHIFT")).releaseKey();
                                    ((KeyGUI)this.GUIforString.get("RSHIFT")).releaseKey();
                                    this.updateLabels();
                                    break;
                                }
                                case 17: {
                                    if (!this.ctrl) continue block124;
                                    this.ctrl = false;
                                    ((KeyGUI)this.GUIforString.get("LCTRL")).releaseKey();
                                    ((KeyGUI)this.GUIforString.get("RCTRL")).releaseKey();
                                    this.updateLabels();
                                    break;
                                }
                                case 18: {
                                    if (!this.alt) continue block124;
                                    this.alt = false;
                                    ((KeyGUI)this.GUIforString.get("LALT")).releaseKey();
                                    ((KeyGUI)this.GUIforString.get("RALT")).releaseKey();
                                    this.updateLabels();
                                    break;
                                }
                                case 20: {
                                    keyGUI2 = (KeyGUI)this.GUIforString.get("CAPS_LOCK");
                                    keyGUI2.releaseKey();
                                    break;
                                }
                                case 8: {
                                    keyGUI2 = (KeyGUI)this.GUIforString.get("BACK_SPACE");
                                    keyGUI2.releaseKey();
                                    break;
                                }
                                case 10: {
                                    keyGUI2 = (KeyGUI)this.GUIforString.get("ENTER");
                                    keyGUI2.releaseKey();
                                    break;
                                }
                                case 9: {
                                    keyGUI2 = (KeyGUI)this.GUIforString.get("TAB");
                                    keyGUI2.releaseKey();
                                    break;
                                }
                                case 32: {
                                    keyGUI2 = (KeyGUI)this.GUIforString.get("SPACE");
                                    keyGUI2.releaseKey();
                                    break;
                                }
                                default: {
                                    string2 = "";
                                    c2 = keyEvent.getKeyChar();
                                    if ('a' <= c2 && c2 <= 'z') {
                                        string2 = string2 + c2;
                                    } else if ('A' <= c2 && c2 <= 'Z') {
                                        string2 = string2 + Character.toLowerCase(c2);
                                    } else {
                                        switch (c2) {
                                            case '`': {
                                                string2 = string2 + c2;
                                                break;
                                            }
                                            case '1': {
                                                string2 = string2 + c2;
                                                break;
                                            }
                                            case '2': {
                                                string2 = string2 + c2;
                                                break;
                                            }
                                            case '3': {
                                                string2 = string2 + c2;
                                                break;
                                            }
                                            case '4': {
                                                string2 = string2 + c2;
                                                break;
                                            }
                                            case '5': {
                                                string2 = string2 + c2;
                                                break;
                                            }
                                            case '6': {
                                                string2 = string2 + c2;
                                                break;
                                            }
                                            case '7': {
                                                string2 = string2 + c2;
                                                break;
                                            }
                                            case '8': {
                                                string2 = string2 + c2;
                                                break;
                                            }
                                            case '9': {
                                                string2 = string2 + c2;
                                                break;
                                            }
                                            case '0': {
                                                string2 = string2 + c2;
                                                break;
                                            }
                                            case '-': {
                                                string2 = string2 + c2;
                                                break;
                                            }
                                            case '=': {
                                                string2 = string2 + c2;
                                                break;
                                            }
                                            case '[': {
                                                string2 = string2 + c2;
                                                break;
                                            }
                                            case ']': {
                                                string2 = string2 + c2;
                                                break;
                                            }
                                            case ';': {
                                                string2 = string2 + c2;
                                                break;
                                            }
                                            case '\'': {
                                                string2 = string2 + c2;
                                                break;
                                            }
                                            case '#': {
                                                string2 = string2 + c2;
                                                break;
                                            }
                                            case '\\': {
                                                string2 = string2 + c2;
                                                break;
                                            }
                                            case ',': {
                                                string2 = string2 + c2;
                                                break;
                                            }
                                            case '.': {
                                                string2 = string2 + c2;
                                                break;
                                            }
                                            case '/': {
                                                string2 = string2 + c2;
                                                break;
                                            }
                                            case '\u00ac': {
                                                string2 = string2 + '`';
                                                break;
                                            }
                                            case '!': {
                                                string2 = string2 + '1';
                                                break;
                                            }
                                            case '\"': {
                                                string2 = string2 + '2';
                                                break;
                                            }
                                            case '\u00a3': {
                                                string2 = string2 + '3';
                                                break;
                                            }
                                            case '$': {
                                                string2 = string2 + '4';
                                                break;
                                            }
                                            case '%': {
                                                string2 = string2 + '5';
                                                break;
                                            }
                                            case '^': {
                                                string2 = string2 + '6';
                                                break;
                                            }
                                            case '&': {
                                                string2 = string2 + '7';
                                                break;
                                            }
                                            case '*': {
                                                string2 = string2 + '8';
                                                break;
                                            }
                                            case '(': {
                                                string2 = string2 + '9';
                                                break;
                                            }
                                            case ')': {
                                                string2 = string2 + '0';
                                                break;
                                            }
                                            case '_': {
                                                string2 = string2 + '-';
                                                break;
                                            }
                                            case '+': {
                                                string2 = string2 + '=';
                                                break;
                                            }
                                            case '{': {
                                                string2 = string2 + '[';
                                                break;
                                            }
                                            case '}': {
                                                string2 = string2 + ']';
                                                break;
                                            }
                                            case ':': {
                                                string2 = string2 + ';';
                                                break;
                                            }
                                            case '@': {
                                                string2 = string2 + '\'';
                                                break;
                                            }
                                            case '~': {
                                                string2 = string2 + '#';
                                                break;
                                            }
                                            case '|': {
                                                string2 = string2 + '\\';
                                                break;
                                            }
                                            case '<': {
                                                string2 = string2 + ',';
                                                break;
                                            }
                                            case '>': {
                                                string2 = string2 + '.';
                                                break;
                                            }
                                            case '?': {
                                                string2 = string2 + '/';
                                            }
                                        }
                                    }
                                    keyGUI2 = (KeyGUI)this.GUIforString.get(string2);
                                    if (keyGUI2 == null) continue block124;
                                    keyGUI2.releaseKey();
                                }
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.jobs.notifyAll();
            }
            try {
                Thread.sleep(150L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    public void addJob(Object object) {
        List list = this.jobs;
        synchronized (list) {
            this.jobs.add(object);
            this.jobs.notifyAll();
        }
    }

    public void update(LocaleHandler localeHandler, State state) {
        if (localeHandler == this.handler && state == this.state) {
            return;
        }
        this.newHandler = localeHandler;
        this.newState = state;
        this.addJob("UPDATE");
    }

    protected void update() {
        Object object;
        Iterator iterator;
        if (this.newHandler != this.handler) {
            this.handler = this.newHandler;
            this.state = this.newState;
            if (this.window instanceof Frame) {
                ((Frame)this.window).setTitle(this.handler.locale.getDisplayLanguage() + " (" + this.handler.locale.getVariant() + ") keyboard map");
            }
            this.labelForKey.clear();
            iterator = this.handler.getKeyCap();
            object = iterator.keySet().iterator();
            while (object.hasNext()) {
                Key key = (Key)object.next();
                JLabel jLabel = new JLabel();
                jLabel.setFont(GateIM.getKeyboardFont());
                jLabel.setText((String)iterator.get(key));
                this.labelForKey.put(key, jLabel);
            }
            this.updateLabels();
        }
        if (this.newState != this.state) {
            this.state = this.newState;
            iterator = this.highlightedKeys.iterator();
            while (iterator.hasNext()) {
                ((KeyGUI)iterator.next()).unHighlight();
            }
            this.highlightedKeys.clear();
            if (this.state != this.handler.getInitialState()) {
                iterator = this.state.transitionFunction.keySet().iterator();
                while (iterator.hasNext()) {
                    object = this.guiForKey((Key)iterator.next());
                    if (object == null) continue;
                    ((KeyGUI)object).highlight();
                    this.highlightedKeys.add(object);
                }
            }
        }
    }

    protected void updateLabels() {
        Component[] componentArray = this.contentPane.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            if (componentArray[n] instanceof KeyGUI) {
                ((KeyGUI)componentArray[n]).updateLabel();
            }
            ++n;
        }
        this.fixShape();
    }

    protected void fixShape() {
        int[][] nArray = ((GridBagLayout)this.contentPane.getLayout()).getLayoutDimensions();
        ((GridBagLayout)this.contentPane.getLayout()).columnWidths = nArray[0];
        ((GridBagLayout)this.contentPane.getLayout()).rowHeights = nArray[1];
        this.window.pack();
        this.contentPane.repaint(100L);
    }

    protected KeyGUI guiForKey(Key key) {
        boolean bl;
        char c = key.keyChar;
        boolean bl2 = false;
        if (Character.isUpperCase(c)) {
            c = Character.toLowerCase(c);
            bl2 = true;
        }
        boolean bl3 = (key.modifiers & 2) > 0;
        boolean bl4 = bl = (key.modifiers & 8) > 0;
        if (this.shift == bl2 && this.ctrl == bl3 && this.alt == bl) {
            return (KeyGUI)this.GUIforString.get("" + c);
        }
        return null;
    }

    public void setShift(boolean bl) {
        this.shift = bl;
    }

    public void setAlt(boolean bl) {
        this.alt = bl;
    }

    public void setCtrl(boolean bl) {
        this.ctrl = bl;
    }

    public class KeyGUI
    extends JPanel {
        Box leftBox;
        JLabel leftUpLabel = new JLabel();
        JLabel leftDownLabel = new JLabel();
        Component centerLabel;
        char low;
        char up;
        Border normalBorder;
        Border highlightedBorder;

        public KeyGUI(String string, char c, char c2, JLabel jLabel) {
            this.setBackground(Color.lightGray);
            this.low = c;
            this.up = c2;
            this.leftBox = Box.createVerticalBox();
            if (c2 > '\u0000') {
                this.leftUpLabel.setFont(this.leftUpLabel.getFont().deriveFont(10.0f));
                this.leftUpLabel.setText("" + c2);
                this.leftBox.add(this.leftUpLabel);
            } else {
                this.leftBox.add(placeHolder);
            }
            if (c > '\u0000') {
                this.leftDownLabel.setFont(this.leftDownLabel.getFont().deriveFont(10.0f));
                this.leftDownLabel.setText("" + c);
                this.leftBox.add(this.leftDownLabel);
            } else {
                this.leftBox.add(placeHolder);
            }
            this.leftBox.add(Box.createVerticalGlue());
            this.centerLabel = jLabel == null ? placeHolder : jLabel;
            this.setLayout(new BoxLayout(this, 0));
            this.add(this.leftBox);
            this.add(Box.createHorizontalGlue());
            this.add(this.centerLabel);
            this.normalBorder = new CompoundBorder(new BevelBorder(0), new EmptyBorder(2, 3, 2, 3));
            this.highlightedBorder = new CompoundBorder(new BevelBorder(0), new MatteBorder(2, 3, 2, 3, Color.green));
            this.setBorder(this.normalBorder);
            this.addMouseListener(new MouseAdapter(this){
                private final /* synthetic */ KeyGUI this$1;
                {
                    this.this$1 = keyGUI;
                }

                public void mouseClicked(MouseEvent mouseEvent) {
                    char c;
                    int n = 0;
                    if (KeyGUI.access$000((KeyGUI)this.this$1).ctrl) {
                        n |= 2;
                    }
                    if (KeyGUI.access$000((KeyGUI)this.this$1).alt) {
                        n |= 8;
                    }
                    if ((c = KeyGUI.access$000((KeyGUI)this.this$1).shift ? this.this$1.up : this.this$1.low) != '\u0000') {
                        KeyGUI.access$000((KeyGUI)this.this$1).im.dispatchEvent(new KeyEvent(KeyGUI.access$000((KeyGUI)this.this$1).window, 400, System.currentTimeMillis(), n, 0, c));
                    }
                }

                public void mousePressed(MouseEvent mouseEvent) {
                    char c = KeyGUI.access$000((KeyGUI)this.this$1).shift ? this.this$1.up : this.this$1.low;
                    if (c != '\u0000') {
                        this.this$1.pressKey();
                    }
                }

                public void mouseReleased(MouseEvent mouseEvent) {
                    char c = KeyGUI.access$000((KeyGUI)this.this$1).shift ? this.this$1.up : this.this$1.low;
                    if (c != '\u0000') {
                        this.this$1.releaseKey();
                    }
                }
            });
        }

        public void updateLabel() {
            if (this.low == '\u0000' || this.up == '\u0000') {
                return;
            }
            this.remove(this.centerLabel);
            int n = 0;
            if (KeyboardMap.this.ctrl) {
                n |= 2;
            }
            if (KeyboardMap.this.alt) {
                n |= 8;
            }
            Key key = KeyboardMap.this.shift ? new Key(this.up, n) : new Key(this.low, n);
            this.centerLabel = (JLabel)KeyboardMap.this.labelForKey.get(key);
            if (this.centerLabel == null) {
                this.centerLabel = placeHolder;
            }
            this.add(this.centerLabel);
        }

        public void pressKey() {
            this.setBackground(Color.darkGray);
        }

        public void releaseKey() {
            this.setBackground(Color.lightGray);
        }

        public void highlight() {
            this.setBorder(this.highlightedBorder);
        }

        public void unHighlight() {
            this.setBorder(this.normalBorder);
        }

        static /* synthetic */ KeyboardMap access$000(KeyGUI keyGUI) {
            return keyGUI.KeyboardMap.this;
        }
    }
}

