/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.Printer;
import com.sun.media.sound.Toolkit;

class CircularBuffer {
    boolean convertSign = false;
    boolean convertByteOrder = false;
    private byte[] array;
    private long bytesWritten = 0L;
    private long bytesRead = 0L;
    private long end = -1L;

    CircularBuffer(int size, boolean convertSign, boolean convertByteOrder) {
        this.array = new byte[size];
        this.convertSign = convertSign;
        this.convertByteOrder = convertByteOrder;
    }

    int bytesAvailableToRead() {
        return (int)(this.bytesWritten - this.bytesRead);
    }

    int bytesAvailableToWrite() {
        return this.end >= 0L ? 0 : this.array.length - this.bytesAvailableToRead();
    }

    void drain() {
        long targetBytesWritten = this.bytesWritten;
        while (this.bytesRead < targetBytesWritten) {
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    synchronized void flush() {
        this.bytesRead = this.bytesWritten;
    }

    int getByteLength() {
        return this.array.length;
    }

    private int getReadIndex() {
        return (int)(this.bytesRead % (long)this.array.length);
    }

    private int getWriteIndex() {
        return (int)(this.bytesWritten % (long)this.array.length);
    }

    synchronized void markEnd() {
        this.end = this.bytesWritten;
    }

    synchronized int read(byte[] b, int off, int len) {
        int totalBytesToRead;
        if (Printer.verbose) {
            Printer.verbose("CircularBuffer: read: b: " + b + " off: " + off + " len: " + len);
        }
        if (this.end >= 0L && this.bytesRead >= this.bytesWritten) {
            return -1;
        }
        int bytesRemainingToRead = totalBytesToRead = Math.min(len, this.bytesAvailableToRead());
        while (bytesRemainingToRead > 0) {
            int bytesToRead = bytesRemainingToRead;
            bytesToRead = Math.min(bytesToRead, this.array.length - this.getReadIndex());
            System.arraycopy(this.array, this.getReadIndex(), b, off, bytesToRead);
            this.bytesRead += (long)bytesToRead;
            bytesRemainingToRead -= bytesToRead;
            off += bytesToRead;
        }
        if (Printer.verbose) {
            Printer.verbose("CircularBuffer: read: returning: " + totalBytesToRead);
        }
        return totalBytesToRead;
    }

    synchronized int skip(int len) {
        int bytesToSkip = Math.min(len, this.bytesAvailableToRead());
        this.bytesRead += (long)bytesToSkip;
        return bytesToSkip;
    }

    synchronized int write(byte[] b, int off, int len) {
        if (Printer.verbose) {
            Printer.verbose("CircularBuffer: write: b: " + b + " off: " + off + " len: " + len);
        }
        if (this.end >= 0L || len == 0) {
            return 0;
        }
        int totalBytesToWrite = Math.min(len, this.bytesAvailableToWrite());
        if (this.convertSign) {
            Toolkit.getUnsigned8(b, off, totalBytesToWrite);
        } else if (this.convertByteOrder) {
            totalBytesToWrite -= totalBytesToWrite % 2;
            Toolkit.getByteSwapped(b, off, totalBytesToWrite);
        }
        int bytesRemainingToWrite = totalBytesToWrite;
        while (bytesRemainingToWrite > 0) {
            int bytesToWrite = bytesRemainingToWrite;
            bytesToWrite = Math.min(bytesToWrite, this.array.length - this.getWriteIndex());
            System.arraycopy(b, off, this.array, this.getWriteIndex(), bytesToWrite);
            this.bytesWritten += (long)bytesToWrite;
            bytesRemainingToWrite -= bytesToWrite;
            off += bytesToWrite;
        }
        if (Printer.verbose) {
            Printer.verbose("CircularBuffer: write: returning: " + totalBytesToWrite);
        }
        return totalBytesToWrite;
    }

    synchronized int writeover(byte[] b, int off, int len) {
        int bytesDumped = 0;
        int totalLen = this.getByteLength();
        if (len > totalLen) {
            bytesDumped = len - totalLen;
            off += bytesDumped;
            len = totalLen;
            this.flush();
        } else if (len > this.bytesAvailableToWrite()) {
            bytesDumped = len - this.bytesAvailableToWrite();
            this.skip(bytesDumped);
        }
        this.write(b, off, len);
        return bytesDumped;
    }
}

