/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.midi;

import java.util.Vector;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiEvent;

public class Track {
    protected Vector events = new Vector();

    Track() {
        MetaMessage eot = new MetaMessage();
        try {
            eot.setMessage(47, new byte[0], 0);
        }
        catch (InvalidMidiDataException invalidMidiDataException) {}
        MidiEvent eotevent = new MidiEvent(eot, 0L);
        this.events.addElement(eotevent);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean add(MidiEvent event) {
        Vector vector = this.events;
        synchronized (vector) {
            MetaMessage mm;
            if (this.events.contains(event)) return false;
            if (event.getMessage().getStatus() == 255 && (mm = (MetaMessage)event.getMessage()).getType() == 47) {
                MidiEvent eot = (MidiEvent)this.events.elementAt(this.events.size() - 1);
                if (event.getTick() <= eot.getTick()) return true;
                eot.setTick(event.getTick());
                return true;
            }
            if (this.events.size() == 0) {
                this.events.addElement(event);
                return true;
            }
            int i = this.events.size();
            while (i > 0) {
                if (event.getTick() >= ((MidiEvent)this.events.elementAt(i - 1)).getTick()) break;
                --i;
            }
            if (i == this.events.size()) {
                ((MidiEvent)this.events.elementAt(i - 1)).setTick(event.getTick());
                this.events.insertElementAt(event, i - 1);
                return true;
            } else {
                this.events.insertElementAt(event, i);
            }
            return true;
        }
    }

    public MidiEvent get(int index) throws ArrayIndexOutOfBoundsException {
        return (MidiEvent)this.events.elementAt(index);
    }

    public boolean remove(MidiEvent event) {
        Vector vector = this.events;
        synchronized (vector) {
            boolean bl = this.events.removeElement(event);
            Object var4_4 = null;
            return bl;
        }
    }

    public int size() {
        return this.events.size();
    }

    public long ticks() {
        return ((MidiEvent)this.events.lastElement()).getTick();
    }
}

