/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.customizer;

import com.sun.media.customizer.I18N;
import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.zip.ZipFile;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class GeneralPane
extends JPanel
implements ActionListener {
    public static final int MFILE = 0;
    public static final int RTPREC = 1;
    public static final int CAPTURE = 2;
    public static final int PLAY = 3;
    public static final int RTPTRANS = 4;
    public static final int TRANSCODE = 5;
    public static final int GUI = 6;
    public static final int STUDIO = 7;
    public static final int BEAN = 8;
    JFrame parent;
    String srcJARname = "jmf.jar";
    String dstJARname = "custom.jar";
    JButton bsrc;
    JButton bdst;
    JTextField srcFile;
    JTextField dstFile;
    JCheckBox[] funcs = new JCheckBox[9];
    JCheckBox twoJar;
    boolean[] resultFuncs = new boolean[9];
    int release = 0;

    public GeneralPane(JFrame jFrame) {
        this.parent = jFrame;
        this.bsrc = new JButton(I18N.getResource("GeneralPane.Browse"));
        this.bdst = new JButton(I18N.getResource("GeneralPane.Browse"));
        this.bsrc.addActionListener(this);
        this.bdst.addActionListener(this);
        this.srcFile = new JTextField(this.srcJARname, 20);
        this.dstFile = new JTextField(this.dstJARname, 20);
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        jPanel.add(new JLabel(I18N.getResource("GeneralPane.SrcJar")));
        jPanel.add(this.srcFile);
        jPanel.add(this.bsrc);
        jPanel2.add(new JLabel(I18N.getResource("GeneralPane.DstJar")));
        jPanel2.add(this.dstFile);
        jPanel2.add(this.bdst);
        this.twoJar = new JCheckBox(I18N.getResource("GeneralPane.twoJar"), false);
        jPanel3.add(this.twoJar);
        JPanel jPanel4 = new JPanel(new GridLayout(3, 1));
        jPanel4.add(jPanel);
        jPanel4.add(jPanel2);
        jPanel4.add(jPanel3);
        JPanel jPanel5 = this.createFuncPane();
        this.setLayout(new BorderLayout());
        this.add("South", jPanel4);
        this.add("Center", jPanel5);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.bsrc) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setCurrentDirectory(new File("."));
            jFileChooser.setSelectedFile(new File(this.srcJARname));
            int n = jFileChooser.showOpenDialog(this.parent);
            if (n == 0) {
                this.srcJARname = jFileChooser.getSelectedFile() != null ? jFileChooser.getSelectedFile().getAbsolutePath() : "nothing";
                this.srcFile.setText(this.srcJARname);
            }
        } else if (actionEvent.getSource() == this.bdst) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setCurrentDirectory(new File("."));
            jFileChooser.setSelectedFile(new File(this.dstJARname));
            int n = jFileChooser.showSaveDialog(this.parent);
            if (n == 0) {
                this.dstJARname = jFileChooser.getSelectedFile() != null ? jFileChooser.getSelectedFile().getAbsolutePath() : "nothing";
                this.dstFile.setText(this.dstJARname);
            }
        }
    }

    public String getSrcJARName() {
        this.srcJARname = this.srcFile.getText();
        return this.srcJARname;
    }

    public String getDstJARName() {
        this.dstJARname = this.dstFile.getText();
        return this.dstJARname;
    }

    private JPanel createFuncPane() {
        this.funcs[0] = new JCheckBox(I18N.getResource("GeneralPane.MFILES"), true);
        this.funcs[1] = new JCheckBox(I18N.getResource("GeneralPane.RTPRECV"), false);
        this.funcs[2] = new JCheckBox(I18N.getResource("GeneralPane.CAPTURE"), false);
        this.funcs[3] = new JCheckBox(I18N.getResource("GeneralPane.PLAY"), true);
        this.funcs[4] = new JCheckBox(I18N.getResource("GeneralPane.RTPTRANS"), false);
        this.funcs[5] = new JCheckBox(I18N.getResource("GeneralPane.TRANSCODE"), false);
        this.funcs[6] = new JCheckBox(I18N.getResource("GeneralPane.GUI"), true);
        this.funcs[7] = new JCheckBox(I18N.getResource("GeneralPane.DEMO"), false);
        this.funcs[8] = new JCheckBox(I18N.getResource("GeneralPane.BEAN"), false);
        JPanel jPanel = new JPanel(new GridLayout(3, 1));
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), I18N.getResource("GeneralPane.MSOURCE")));
        int n = 0;
        while (n < 3) {
            jPanel.add(this.funcs[n]);
            ++n;
        }
        JPanel jPanel2 = new JPanel(new GridLayout(3, 1));
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), I18N.getResource("GeneralPane.MSINK")));
        int n2 = 3;
        while (n2 < 6) {
            jPanel2.add(this.funcs[n2]);
            ++n2;
        }
        JPanel jPanel3 = new JPanel(new GridLayout(3, 1));
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), I18N.getResource("GeneralPane.OPTCOMP")));
        int n3 = 7;
        while (n3 < 9) {
            jPanel3.add(this.funcs[n3]);
            ++n3;
        }
        JPanel jPanel4 = new JPanel(new GridLayout(1, 3));
        jPanel4.add(jPanel);
        jPanel4.add(jPanel2);
        jPanel4.add(jPanel3);
        return jPanel4;
    }

    public boolean[] getState() {
        int n = 0;
        while (n < 9) {
            this.resultFuncs[n] = this.funcs[n].isEnabled() && this.funcs[n].isSelected();
            ++n;
        }
        return this.resultFuncs;
    }

    public boolean checking(boolean[] blArray, JFrame jFrame) {
        boolean bl = blArray[0] || blArray[1] || blArray[2];
        boolean bl2 = blArray[3] || blArray[4] || blArray[5];
        this.srcJARname = this.srcFile.getText();
        this.dstJARname = this.dstFile.getText();
        if (!(bl &= bl2)) {
            JOptionPane.showMessageDialog(jFrame, I18N.getResource("GeneralPane.s1s1"), I18N.getResource("GeneralPane.WRONGSEL"), 0);
            return false;
        }
        if (this.srcJARname == null || this.srcJARname.length() <= 0) {
            JOptionPane.showMessageDialog(jFrame, I18N.getResource("GeneralPane.INPUTSRCJAR"), I18N.getResource("GeneralPane.BADSRCJAR"), 0);
            return false;
        }
        File file = new File(this.srcJARname);
        if (!file.exists() || file.length() == 0L) {
            JOptionPane.showMessageDialog(jFrame, I18N.getResource("GeneralPane.SRCJARNOTEXIST"), I18N.getResource("GeneralPane.BADSRCJAR"), 0);
            return false;
        }
        try {
            ZipFile zipFile = new ZipFile(file);
            this.release = zipFile.getEntry("com/sun/media/codec/video/cinepakpro/NativeEncoder$DC.class") != null ? 2 : (zipFile.getEntry("com/ibm/media/codec/audio/ACMCodec.class") != null ? 3 : 1);
            zipFile.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.dstJARname == null || this.dstJARname.length() <= 0) {
            JOptionPane.showMessageDialog(jFrame, I18N.getResource("GeneralPane.INPUTDSTJAR"), I18N.getResource("GeneralPane.BADTARJAR"), 0);
            return false;
        }
        if (this.srcJARname.equalsIgnoreCase(this.dstJARname)) {
            JOptionPane.showMessageDialog(jFrame, I18N.getResource("GeneralPane.SRCDSTJAR"), I18N.getResource("GeneralPane.BADTARJAR"), 0);
            return false;
        }
        return true;
    }

    public int getRelease() {
        return this.release;
    }

    public boolean genTwoJars() {
        return this.twoJar.isEnabled() && this.twoJar.isSelected();
    }
}

