/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.player;

import com.jniwrapper.DefaultLibraryLoader;
import com.jniwrapper.Int32;
import com.jniwrapper.win32.automation.Automation;
import com.jniwrapper.win32.automation.OleContainer;
import com.jniwrapper.win32.automation.types.BStr;
import com.jniwrapper.win32.automation.types.Variant;
import com.jniwrapper.win32.com.IUnknown;
import com.jniwrapper.win32.com.types.CLSID;
import com.jniwrapper.win32.ole.OleFunctions;
import java.awt.Component;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.StringTokenizer;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import mpi.eudico.client.annotator.ElanLayoutManager;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.gui.FormattedMessageDlg;
import mpi.eudico.client.annotator.player.ElanMediaPlayer;
import mpi.eudico.client.annotator.player.NoPlayerException;
import mpi.eudico.client.mediacontrol.ControllerEvent;
import mpi.eudico.client.mediacontrol.ControllerListener;
import mpi.eudico.client.mediacontrol.ControllerManager;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.util.TimeFormatter;

public class NativeMediaPlayerWindowsQT
extends ControllerManager
implements ElanMediaPlayer,
ControllerListener,
ActionListener {
    private static final String QTActiveXPlugin_INTERFACE_ID = "{02BF25D5-8C17-4B23-BC80-D3488ABDDC6B}";
    private MediaDescriptor mediaDescriptor;
    private boolean playing;
    private long offset;
    private long duration;
    private float aspectRatio;
    private long millisPerSample;
    private JPopupMenu popup;
    private JMenuItem durationItem;
    protected JMenuItem detachItem;
    private JMenuItem infoItem;
    private ElanLayoutManager layoutManager;
    private boolean detached;
    private final OleContainer oleContainer;
    private Automation automation;
    private VisualComponent visualComponent;
    private long now;
    private float rate;
    private float timeScale;
    private long stopTime;

    public NativeMediaPlayerWindowsQT(MediaDescriptor mediaDescriptor) throws NoPlayerException {
        try {
            this.mediaDescriptor = mediaDescriptor;
            if (DefaultLibraryLoader.getInstance().findLibrary("jniwrap") == null) {
                DefaultLibraryLoader.getInstance().addPath("lib/java/jniwrapper");
                DefaultLibraryLoader.getInstance().loadLibrary("jniwrap");
            }
            String URLString = mediaDescriptor.mediaURL;
            System.out.println("url: " + URLString);
            OleFunctions.oleInitialize();
            this.oleContainer = new OleContainer();
            this.oleContainer.createObject(CLSID.create((String)QTActiveXPlugin_INTERFACE_ID));
            JFrame sample = new JFrame("Streaming Video");
            sample.getContentPane().add((Component)this.oleContainer);
            sample.setSize(640, 480);
            sample.setVisible(true);
            this.oleContainer.doVerb(-1);
            this.automation = new Automation((IUnknown)this.oleContainer.getOleObject());
            this.automation.invoke("SetURL", new Object[]{new BStr(URLString)});
            this.automation.invoke("SetControllerVisible", new Object[]{new Int32(0)});
            this.automation.invoke("SetTime", new Object[]{new Int32(0)});
            this.timeScale = (float)this.automation.invoke("GetTimeScale").getLVal().getValue() / 1000.0f;
            System.out.println("time scale " + this.automation.invoke("GetTimeScale").getLVal().getValue());
            System.out.println("time scale " + this.timeScale);
            System.out.println("movie size " + this.automation.invoke("GetMovieSize").getLVal().getValue());
            this.aspectRatio = 1.0f;
            this.duration = (long)((float)this.automation.invoke("GetDuration").getLVal().getValue() / this.timeScale);
            this.millisPerSample = 40L;
            this.rate = 1.0f;
            this.start();
            this.stop();
            this.automation.invoke("SetTime", new Object[]{new Int32(0)});
            JPopupMenu.setDefaultLightWeightPopupEnabled(false);
            this.popup = new JPopupMenu();
            this.infoItem = new JMenuItem(ElanLocale.getString((String)"Player.Info"));
            this.infoItem.addActionListener(this);
            this.durationItem = new JMenuItem(ElanLocale.getString((String)"Player.duration") + ":  " + TimeFormatter.toString((long)this.getMediaDuration()));
            this.durationItem.setEnabled(false);
            this.popup.addSeparator();
            this.popup.add(this.infoItem);
            this.popup.add(this.durationItem);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new NoPlayerException("Problem while creating Quicktime based native player");
        }
    }

    public MediaDescriptor getMediaDescriptor() {
        return this.mediaDescriptor;
    }

    public void finalize() {
        OleFunctions.oleUninitialize();
    }

    public String getFrameworkDescription() {
        return "Native Windows Media Framework QT Plugin";
    }

    public synchronized void controllerUpdate(ControllerEvent event) {
    }

    public synchronized void playInterval(long startTime, long stopTime) {
        System.out.println("play interval " + startTime + " - " + stopTime);
        this.setMediaTime(startTime);
        System.out.println("SetEndTime " + (int)((float)stopTime * this.timeScale + (float)this.offset));
        this.setStopTime(stopTime);
        this.start();
    }

    public void setStopTime(long stopTime) {
        this.stopTime = stopTime;
        this.automation.invoke("SetEndTime", new Object[]{new Int32((int)((float)stopTime * this.timeScale + (float)this.offset))});
    }

    public Component getVisualComponent() {
        return this.visualComponent;
    }

    public int getSourceHeight() {
        try {
            Variant wi = this.automation.invoke("GetRectangle");
            if (wi != null) {
                BStr bs = (BStr)wi.getValue();
                System.out.println("Bstr: " + bs.getValue());
                StringTokenizer tokenizer = new StringTokenizer(bs.getValue(), ",");
                tokenizer.nextToken();
                int y = Integer.valueOf(tokenizer.nextToken());
                tokenizer.nextToken();
                int th = Integer.valueOf(tokenizer.nextToken());
                System.out.println("Height: " + (th - y));
                return th - y;
            }
        }
        catch (Exception ex) {
            System.out.println("Could not get height: " + ex.getMessage());
        }
        return 240;
    }

    public int getSourceWidth() {
        try {
            Variant wi = this.automation.invoke("GetRectangle");
            if (wi != null) {
                BStr bs = (BStr)wi.getValue();
                StringTokenizer tokenizer = new StringTokenizer(bs.getValue(), ",");
                int x = Integer.valueOf(tokenizer.nextToken());
                tokenizer.nextToken();
                int tw = Integer.valueOf(tokenizer.nextToken());
                return tw - x;
            }
        }
        catch (Exception ex) {
            System.out.println("Could not get width: " + ex.getMessage());
        }
        return 320;
    }

    public float getAspectRatio() {
        return this.aspectRatio;
    }

    public synchronized void start() {
        System.out.println("start duration: " + this.getMediaDuration());
        System.out.println("start current:  " + this.getMediaTime());
        if (this.getMediaDuration() - this.getMediaTime() < 40L) {
            this.setMediaTime(0L);
        }
        this.automation.invoke("Play");
        this.startControllers();
        while (this.getRate() == 0.0f) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
        }
        this.playing = true;
        new Thread(new PlayerStateWatcher()).start();
    }

    public synchronized void stop() {
        this.automation.invoke("Stop");
        this.stopControllers();
        while (this.getRate() > 0.0f) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
        }
        this.playing = false;
    }

    public boolean isPlaying() {
        return this.playing;
    }

    public long getMilliSecondsPerSample() {
        return this.millisPerSample;
    }

    public void setMilliSecondsPerSample(long milliSeconds) {
        this.millisPerSample = milliSeconds;
    }

    public float getVolume() {
        float volume = this.automation.invoke("GetVolume").getLVal().getValue();
        return volume / 255.0f;
    }

    public void setVolume(float level) {
        this.automation.invoke("SetVolume", new Object[]{new Int32((int)(level * 255.0f))});
    }

    public void setOffset(long offset) {
        this.offset = offset;
        this.mediaDescriptor.timeOrigin = offset;
    }

    public long getOffset() {
        return this.offset;
    }

    public synchronized void setMediaTime(long time) {
        if (this.isPlaying()) {
            this.stop();
        }
        if ((time = (long)((float)time * this.timeScale)) < 0L) {
            time = 0L;
        }
        System.out.println("SetTime " + time);
        this.automation.invoke("SetTime", new Object[]{new Int32((int)(time + this.offset))});
        this.setControllersMediaTime(time);
    }

    public void nextFrame() {
        this.setMediaTime(this.getMediaTime() + this.getMilliSecondsPerSample());
    }

    public void previousFrame() {
        this.setMediaTime(this.getMediaTime() - this.getMilliSecondsPerSample());
    }

    public long getMediaTime() {
        long t = this.automation.invoke("GetTime").getLVal().getValue();
        t = (long)(0.5 + (double)((float)t / this.timeScale));
        return t - this.offset;
    }

    public float getRate() {
        return (float)this.automation.invoke("GetRate").getFltVal().getValue();
    }

    public synchronized void setRate(float rate) {
    }

    public boolean isFrameRateAutoDetected() {
        return false;
    }

    public long getMediaDuration() {
        return this.duration;
    }

    public void setLayoutManager(ElanLayoutManager layoutManager) {
        if (this.layoutManager == null) {
            this.detachItem = new JMenuItem(ElanLocale.getString((String)"Detachable.detach"));
            this.detachItem.addActionListener(this);
            this.popup.insert(this.detachItem, 0);
        }
        this.layoutManager = layoutManager;
    }

    public void updateLocale() {
        this.infoItem.setText(ElanLocale.getString((String)"Player.Info"));
        this.durationItem.setText(ElanLocale.getString((String)"Player.duration") + ":  " + TimeFormatter.toString((long)this.getMediaDuration()));
        if (this.detachItem != null) {
            if (this.detached) {
                this.detachItem.setText(ElanLocale.getString((String)"Detachable.attach"));
            } else {
                this.detachItem.setText(ElanLocale.getString((String)"Detachable.detach"));
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.detachItem) && this.layoutManager != null) {
            if (this.detached) {
                this.layoutManager.attach((Object)this.getVisualComponent());
                this.detachItem.setText(ElanLocale.getString((String)"Detachable.detach"));
                this.detached = false;
            } else {
                this.layoutManager.detach((Object)this.getVisualComponent());
                this.detachItem.setText(ElanLocale.getString((String)"Detachable.attach"));
                this.detached = true;
            }
            this.getVisualComponent().addNotify();
        } else if (e.getSource() == this.infoItem) {
            new FormattedMessageDlg((ElanMediaPlayer)this);
        }
    }

    public void cleanUpOnClose() {
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() >= 2) {
                if (NativeMediaPlayerWindowsQT.this.layoutManager != null) {
                    NativeMediaPlayerWindowsQT.this.layoutManager.setFirstPlayer((ElanMediaPlayer)NativeMediaPlayerWindowsQT.this);
                }
                return;
            }
            JPopupMenu.setDefaultLightWeightPopupEnabled(false);
            if (SwingUtilities.isRightMouseButton(e)) {
                NativeMediaPlayerWindowsQT.this.popup.show(NativeMediaPlayerWindowsQT.this.getVisualComponent(), e.getPoint().x, e.getPoint().y);
            }
        }
    }

    private class PlayerStateWatcher
    implements Runnable {
        private PlayerStateWatcher() {
        }

        public void run() {
            do {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            } while (NativeMediaPlayerWindowsQT.this.getRate() > 0.0f);
            NativeMediaPlayerWindowsQT.this.stop();
            NativeMediaPlayerWindowsQT.this.setStopTime((long)((float)NativeMediaPlayerWindowsQT.this.getMediaDuration() * NativeMediaPlayerWindowsQT.this.timeScale));
        }
    }

    private class VisualComponent
    extends Panel
    implements ComponentListener,
    HierarchyListener {
        public VisualComponent() {
            this.addComponentListener(this);
            this.addHierarchyListener(this);
        }

        public void componentResized(ComponentEvent e) {
        }

        public void hierarchyChanged(HierarchyEvent e) {
            System.out.println("hierar");
            if (this.isDisplayable()) {
                System.out.println("disp");
                NativeMediaPlayerWindowsQT.this.oleContainer.doVerb(-1);
            }
        }

        public void addNotify() {
            System.out.println("addNotify");
            super.addNotify();
            NativeMediaPlayerWindowsQT.this.oleContainer.doVerb(-1);
        }

        public void removeNotify() {
            System.out.println("removeNotify");
            NativeMediaPlayerWindowsQT.this.oleContainer.doVerb(-3);
            super.removeNotify();
        }

        public void componentShown(ComponentEvent e) {
            System.out.println("compShown");
        }

        public void componentHidden(ComponentEvent e) {
            System.out.println("compHidden");
        }

        public void componentMoved(ComponentEvent e) {
        }
    }
}

