/*
 * File:     FilgraphManager.java
 * Project:  MPI Linguistic Application
 * Date:     12 December 2007
 *
 * Copyright (C) 2001-2008  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.nativemedia.quartztypelib;

import com.jniwrapper.*;

import com.jniwrapper.win32.com.*;

import com.jniwrapper.win32.com.types.*;

import com.jniwrapper.win32.ole.*;

import mpi.eudico.client.annotator.nativemedia.quartztypelib.impl.*;


/**
 * Represents COM coclass FilgraphManager
 */
public class FilgraphManager extends CoClass {
    /** Holds value of property DOCUMENT ME! */
    public static final CLSID CLASS_ID = CLSID.create(
            "{E436EBB3-524F-11CE-9F53-0020AF0BA770}");

    /**
     * Creates a new FilgraphManager instance
     */
    public FilgraphManager() {
    }

    /**
     * Creates a new FilgraphManager instance
     *
     * @param that DOCUMENT ME!
     */
    public FilgraphManager(FilgraphManager that) {
        super(that);
    }

    /**
     * creates coclass and returns its default interface
     */
    public static IMediaControl create(ClsCtx dwClsContext)
        throws ComException {
        final IMediaControlImpl intf = new IMediaControlImpl(CLASS_ID,
                dwClsContext);
        OleFunctions.oleRun(intf);

        return intf;
    }

    /**
     * queries the <code>IMediaControl</code> interface from IUnknown instance
     */
    public static IMediaControl queryInterface(IUnknown unknown)
        throws ComException {
        final IMediaControlImpl result = new IMediaControlImpl();
        unknown.queryInterface(result.getIID(), result);

        return result;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public CLSID getCLSID() {
        return CLASS_ID;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public Object clone() {
        return new FilgraphManager(this);
    }
}
