/*
 * File:     IBasicVideo.java
 * Project:  MPI Linguistic Application
 * Date:     12 December 2007
 *
 * Copyright (C) 2001-2008  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.nativemedia.quartztypelib;

import com.jniwrapper.*;

import com.jniwrapper.win32.*;

import com.jniwrapper.win32.automation.*;

import com.jniwrapper.win32.automation.impl.*;

import com.jniwrapper.win32.automation.types.*;

import com.jniwrapper.win32.com.*;

import com.jniwrapper.win32.com.impl.*;

import com.jniwrapper.win32.com.types.*;

import mpi.eudico.client.annotator.nativemedia.quartztypelib.impl.*;


/**
 * Represents Java interface for COM interface IBasicVideo
 */
public interface IBasicVideo extends IDispatch {
    /** Holds value of property DOCUMENT ME! */
    public static final String INTERFACE_IDENTIFIER = "{56A868B5-0AD4-11CE-B03A-0020AF0BA770}";

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    DoubleFloat getAvgTimePerFrame() throws ComException;

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    Int32 getBitRate() throws ComException;

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    Int32 getBitErrorRate() throws ComException;

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    Int32 getVideoWidth() throws ComException;

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    Int32 getVideoHeight() throws ComException;

    /**
     * DOCUMENT ME!
     *
     * @param pSourceLeft DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    void setSourceLeft(Int32 /*[in]*/ pSourceLeft) throws ComException;

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    Int32 getSourceLeft() throws ComException;

    /**
     * DOCUMENT ME!
     *
     * @param pSourceWidth DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    void setSourceWidth(Int32 /*[in]*/ pSourceWidth) throws ComException;

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    Int32 getSourceWidth() throws ComException;

    /**
     * DOCUMENT ME!
     *
     * @param pSourceTop DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    void setSourceTop(Int32 /*[in]*/ pSourceTop) throws ComException;

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    Int32 getSourceTop() throws ComException;

    /**
     * DOCUMENT ME!
     *
     * @param pSourceHeight DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    void setSourceHeight(Int32 /*[in]*/ pSourceHeight)
        throws ComException;

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    Int32 getSourceHeight() throws ComException;

    /**
     * DOCUMENT ME!
     *
     * @param pDestinationLeft DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    void setDestinationLeft(Int32 /*[in]*/ pDestinationLeft)
        throws ComException;

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    Int32 getDestinationLeft() throws ComException;

    /**
     * DOCUMENT ME!
     *
     * @param pDestinationWidth DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    void setDestinationWidth(Int32 /*[in]*/ pDestinationWidth)
        throws ComException;

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    Int32 getDestinationWidth() throws ComException;

    /**
     * DOCUMENT ME!
     *
     * @param pDestinationTop DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    void setDestinationTop(Int32 /*[in]*/ pDestinationTop)
        throws ComException;

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    Int32 getDestinationTop() throws ComException;

    /**
     * DOCUMENT ME!
     *
     * @param pDestinationHeight DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    void setDestinationHeight(Int32 /*[in]*/ pDestinationHeight)
        throws ComException;

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    Int32 getDestinationHeight() throws ComException;

    /**
     * DOCUMENT ME!
     *
     * @param Left DOCUMENT ME!
     * @param Top DOCUMENT ME!
     * @param Width DOCUMENT ME!
     * @param Height DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    void setSourcePosition(Int32 /*[in]*/ Left, Int32 /*[in]*/ Top,
        Int32 /*[in]*/ Width, Int32 /*[in]*/ Height) throws ComException;

    /**
     * DOCUMENT ME!
     *
     * @param pLeft DOCUMENT ME!
     * @param pTop DOCUMENT ME!
     * @param pWidth DOCUMENT ME!
     * @param pHeight DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    void getSourcePosition(Int32 /*[out]*/ pLeft, Int32 /*[out]*/ pTop,
        Int32 /*[out]*/ pWidth, Int32 /*[out]*/ pHeight)
        throws ComException;

    /**
     * DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    void setDefaultSourcePosition() throws ComException;

    /**
     * DOCUMENT ME!
     *
     * @param Left DOCUMENT ME!
     * @param Top DOCUMENT ME!
     * @param Width DOCUMENT ME!
     * @param Height DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    void setDestinationPosition(Int32 /*[in]*/ Left, Int32 /*[in]*/ Top,
        Int32 /*[in]*/ Width, Int32 /*[in]*/ Height) throws ComException;

    /**
     * DOCUMENT ME!
     *
     * @param pLeft DOCUMENT ME!
     * @param pTop DOCUMENT ME!
     * @param pWidth DOCUMENT ME!
     * @param pHeight DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    void getDestinationPosition(Int32 /*[out]*/ pLeft, Int32 /*[out]*/ pTop,
        Int32 /*[out]*/ pWidth, Int32 /*[out]*/ pHeight)
        throws ComException;

    /**
     * DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    void setDefaultDestinationPosition() throws ComException;

    /**
     * DOCUMENT ME!
     *
     * @param pWidth DOCUMENT ME!
     * @param pHeight DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    void getVideoSize(Int32 /*[out]*/ pWidth, Int32 /*[out]*/ pHeight)
        throws ComException;

    /**
     * DOCUMENT ME!
     *
     * @param StartIndex DOCUMENT ME!
     * @param Entries DOCUMENT ME!
     * @param pRetrieved DOCUMENT ME!
     * @param pPalette DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    void getVideoPaletteEntries(Int32 /*[in]*/ StartIndex,
        Int32 /*[in]*/ Entries, Int32 /*[out]*/ pRetrieved,
        Int32 /*[out]*/ pPalette) throws ComException;

    /**
     * DOCUMENT ME!
     *
     * @param pBufferSize DOCUMENT ME!
     * @param pDIBImage DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    void getCurrentImage(Int32 /*[in,out]*/ pBufferSize,
        Int32 /*[out]*/ pDIBImage) throws ComException;

    /**
     * DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    void isUsingDefaultSource() throws ComException;

    /**
     * DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    void isUsingDefaultDestination() throws ComException;
}
