/*
 * File:     IPinInfo.java
 * Project:  MPI Linguistic Application
 * Date:     12 December 2007
 *
 * Copyright (C) 2001-2008  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.nativemedia.quartztypelib;

import com.jniwrapper.*;

import com.jniwrapper.win32.*;

import com.jniwrapper.win32.automation.*;

import com.jniwrapper.win32.automation.impl.*;

import com.jniwrapper.win32.automation.types.*;

import com.jniwrapper.win32.com.*;

import com.jniwrapper.win32.com.impl.*;

import com.jniwrapper.win32.com.types.*;

import mpi.eudico.client.annotator.nativemedia.quartztypelib.impl.*;


/**
 * Represents Java interface for COM interface IPinInfo
 */
public interface IPinInfo extends IDispatch {
    /** Holds value of property DOCUMENT ME! */
    public static final String INTERFACE_IDENTIFIER = "{56A868BD-0AD4-11CE-B03A-0020AF0BA770}";

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    IUnknown getPin() throws ComException;

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    IDispatch getConnectedTo() throws ComException;

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    IDispatch getConnectionMediaType() throws ComException;

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    IDispatch getFilterInfo() throws ComException;

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    BStr getName() throws ComException;

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    Int32 getDirection() throws ComException;

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    BStr getPinID() throws ComException;

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    IDispatch getMediaTypes() throws ComException;

    /**
     * DOCUMENT ME!
     *
     * @param pPin DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    void connect(IUnknown /*[in]*/ pPin) throws ComException;

    /**
     * DOCUMENT ME!
     *
     * @param pPin DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    void connectDirect(IUnknown /*[in]*/ pPin) throws ComException;

    /**
     * DOCUMENT ME!
     *
     * @param pPin DOCUMENT ME!
     * @param pMediaType DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    void connectWithType(IUnknown /*[in]*/ pPin, IDispatch /*[in]*/ pMediaType)
        throws ComException;

    /**
     * DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    void disconnect() throws ComException;

    /**
     * DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    void render() throws ComException;
}
