/*
 * File:     IQueueCommand.java
 * Project:  MPI Linguistic Application
 * Date:     12 December 2007
 *
 * Copyright (C) 2001-2008  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.nativemedia.quartztypelib;

import com.jniwrapper.*;

import com.jniwrapper.win32.*;

import com.jniwrapper.win32.automation.types.*;

import com.jniwrapper.win32.com.*;

import com.jniwrapper.win32.com.impl.*;

import com.jniwrapper.win32.com.types.*;

import mpi.eudico.client.annotator.nativemedia.quartztypelib.impl.*;


/**
 * Represents Java interface for COM interface IQueueCommand
 */
public interface IQueueCommand extends IUnknown {
    /** Holds value of property DOCUMENT ME! */
    public static final String INTERFACE_IDENTIFIER = "{56A868B7-0AD4-11CE-B03A-0020AF0BA770}";

    /**
     * DOCUMENT ME!
     *
     * @param pCmd DOCUMENT ME!
     * @param time DOCUMENT ME!
     * @param iid DOCUMENT ME!
     * @param dispidMethod DOCUMENT ME!
     * @param wFlags DOCUMENT ME!
     * @param cArgs DOCUMENT ME!
     * @param pDispParams DOCUMENT ME!
     * @param pvarResult DOCUMENT ME!
     * @param puArgErr DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    void invokeAtStreamTime(IDeferredCommand /*[out]*/ pCmd,
        DoubleFloat /*[in]*/ time, GUID /*[in]*/ iid,
        Int32 /*[in]*/ dispidMethod, Int16 /*[in]*/ wFlags,
        Int32 /*[in]*/ cArgs, Variant /*[in]*/ pDispParams,
        Variant /*[in,out]*/ pvarResult, Int16 /*[out]*/ puArgErr)
        throws ComException;

    /**
     * DOCUMENT ME!
     *
     * @param pCmd DOCUMENT ME!
     * @param time DOCUMENT ME!
     * @param iid DOCUMENT ME!
     * @param dispidMethod DOCUMENT ME!
     * @param wFlags DOCUMENT ME!
     * @param cArgs DOCUMENT ME!
     * @param pDispParams DOCUMENT ME!
     * @param pvarResult DOCUMENT ME!
     * @param puArgErr DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    void invokeAtPresentationTime(IDeferredCommand /*[out]*/ pCmd,
        DoubleFloat /*[in]*/ time, GUID /*[in]*/ iid,
        Int32 /*[in]*/ dispidMethod, Int16 /*[in]*/ wFlags,
        Int32 /*[in]*/ cArgs, Variant /*[in]*/ pDispParams,
        Variant /*[in,out]*/ pvarResult, Int16 /*[out]*/ puArgErr)
        throws ComException;
}
