/*
 * File:     IVideoWindow.java
 * Project:  MPI Linguistic Application
 * Date:     12 December 2007
 *
 * Copyright (C) 2001-2008  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.nativemedia.quartztypelib;

import com.jniwrapper.*;

import com.jniwrapper.win32.*;

import com.jniwrapper.win32.automation.*;

import com.jniwrapper.win32.automation.impl.*;

import com.jniwrapper.win32.automation.types.*;

import com.jniwrapper.win32.com.*;

import com.jniwrapper.win32.com.impl.*;

import com.jniwrapper.win32.com.types.*;

import mpi.eudico.client.annotator.nativemedia.quartztypelib.impl.*;


/**
 * Represents Java interface for COM interface IVideoWindow
 */
public interface IVideoWindow extends IDispatch {
    /** Holds value of property DOCUMENT ME! */
    public static final String INTERFACE_IDENTIFIER = "{56A868B4-0AD4-11CE-B03A-0020AF0BA770}";

    /**
     * DOCUMENT ME!
     *
     * @param strCaption DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    void setCaption(BStr /*[in]*/ strCaption) throws ComException;

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    BStr getCaption() throws ComException;

    /**
     * DOCUMENT ME!
     *
     * @param WindowStyle DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    void setWindowStyle(Int32 /*[in]*/ WindowStyle) throws ComException;

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    Int32 getWindowStyle() throws ComException;

    /**
     * DOCUMENT ME!
     *
     * @param WindowStyleEx DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    void setWindowStyleEx(Int32 /*[in]*/ WindowStyleEx)
        throws ComException;

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    Int32 getWindowStyleEx() throws ComException;

    /**
     * DOCUMENT ME!
     *
     * @param AutoShow DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    void setAutoShow(Int32 /*[in]*/ AutoShow) throws ComException;

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    Int32 getAutoShow() throws ComException;

    /**
     * DOCUMENT ME!
     *
     * @param WindowState DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    void setWindowState(Int32 /*[in]*/ WindowState) throws ComException;

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    Int32 getWindowState() throws ComException;

    /**
     * DOCUMENT ME!
     *
     * @param pBackgroundPalette DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    void setBackgroundPalette(Int32 /*[in]*/ pBackgroundPalette)
        throws ComException;

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    Int32 getBackgroundPalette() throws ComException;

    /**
     * DOCUMENT ME!
     *
     * @param pVisible DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    void setVisible(Int32 /*[in]*/ pVisible) throws ComException;

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    Int32 getVisible() throws ComException;

    /**
     * DOCUMENT ME!
     *
     * @param pLeft DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    void setLeft(Int32 /*[in]*/ pLeft) throws ComException;

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    Int32 getLeft() throws ComException;

    /**
     * DOCUMENT ME!
     *
     * @param pWidth DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    void setWidth(Int32 /*[in]*/ pWidth) throws ComException;

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    Int32 getWidth() throws ComException;

    /**
     * DOCUMENT ME!
     *
     * @param pTop DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    void setTop(Int32 /*[in]*/ pTop) throws ComException;

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    Int32 getTop() throws ComException;

    /**
     * DOCUMENT ME!
     *
     * @param pHeight DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    void setHeight(Int32 /*[in]*/ pHeight) throws ComException;

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    Int32 getHeight() throws ComException;

    /**
     * DOCUMENT ME!
     *
     * @param Owner DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    void setOwner(LongPtr /*[in]*/ Owner) throws ComException;

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    LongPtr getOwner() throws ComException;

    /**
     * DOCUMENT ME!
     *
     * @param Drain DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    void setMessageDrain(LongPtr /*[in]*/ Drain) throws ComException;

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    LongPtr getMessageDrain() throws ComException;

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    Int32 getBorderColor() throws ComException;

    /**
     * DOCUMENT ME!
     *
     * @param Color DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    void setBorderColor(Int32 /*[in]*/ Color) throws ComException;

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    Int32 getFullScreenMode() throws ComException;

    /**
     * DOCUMENT ME!
     *
     * @param FullScreenMode DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    void setFullScreenMode(Int32 /*[in]*/ FullScreenMode)
        throws ComException;

    /**
     * DOCUMENT ME!
     *
     * @param Focus DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    void setWindowForeground(Int32 /*[in]*/ Focus) throws ComException;

    /**
     * DOCUMENT ME!
     *
     * @param hwnd DOCUMENT ME!
     * @param uMsg DOCUMENT ME!
     * @param wParam DOCUMENT ME!
     * @param lParam DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    void notifyOwnerMessage(LongPtr /*[in]*/ hwnd, Int32 /*[in]*/ uMsg,
        LongPtr /*[in]*/ wParam, LongPtr /*[in]*/ lParam)
        throws ComException;

    /**
     * DOCUMENT ME!
     *
     * @param Left DOCUMENT ME!
     * @param Top DOCUMENT ME!
     * @param Width DOCUMENT ME!
     * @param Height DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    void setWindowPosition(Int32 /*[in]*/ Left, Int32 /*[in]*/ Top,
        Int32 /*[in]*/ Width, Int32 /*[in]*/ Height) throws ComException;

    /**
     * DOCUMENT ME!
     *
     * @param pLeft DOCUMENT ME!
     * @param pTop DOCUMENT ME!
     * @param pWidth DOCUMENT ME!
     * @param pHeight DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    void getWindowPosition(Int32 /*[out]*/ pLeft, Int32 /*[out]*/ pTop,
        Int32 /*[out]*/ pWidth, Int32 /*[out]*/ pHeight)
        throws ComException;

    /**
     * DOCUMENT ME!
     *
     * @param pWidth DOCUMENT ME!
     * @param pHeight DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    void getMinIdealImageSize(Int32 /*[out]*/ pWidth, Int32 /*[out]*/ pHeight)
        throws ComException;

    /**
     * DOCUMENT ME!
     *
     * @param pWidth DOCUMENT ME!
     * @param pHeight DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    void getMaxIdealImageSize(Int32 /*[out]*/ pWidth, Int32 /*[out]*/ pHeight)
        throws ComException;

    /**
     * DOCUMENT ME!
     *
     * @param pLeft DOCUMENT ME!
     * @param pTop DOCUMENT ME!
     * @param pWidth DOCUMENT ME!
     * @param pHeight DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    void getRestorePosition(Int32 /*[out]*/ pLeft, Int32 /*[out]*/ pTop,
        Int32 /*[out]*/ pWidth, Int32 /*[out]*/ pHeight)
        throws ComException;

    /**
     * DOCUMENT ME!
     *
     * @param HideCursor DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    void hideCursor(Int32 /*[in]*/ HideCursor) throws ComException;

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    Int32 isCursorHidden() throws ComException;
}
