/*
 * File:     IAMStatsImpl.java
 * Project:  MPI Linguistic Application
 * Date:     12 December 2007
 *
 * Copyright (C) 2001-2008  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.nativemedia.quartztypelib.impl;

import com.jniwrapper.*;

import com.jniwrapper.win32.*;

import com.jniwrapper.win32.automation.*;

import com.jniwrapper.win32.automation.impl.*;

import com.jniwrapper.win32.automation.types.*;

import com.jniwrapper.win32.com.*;

import com.jniwrapper.win32.com.impl.*;

import com.jniwrapper.win32.com.types.*;

import mpi.eudico.client.annotator.nativemedia.quartztypelib.*;


/**
 * Represents COM interface IAMStats
 */
public class IAMStatsImpl extends IDispatchImpl implements IAMStats {
    /** Holds value of property DOCUMENT ME! */
    public static final String INTERFACE_IDENTIFIER = IAMStats.INTERFACE_IDENTIFIER;

    /** Holds value of property DOCUMENT ME! */
    private static final IID _iid = IID.create(INTERFACE_IDENTIFIER);

    /**
     * Creates a new IAMStatsImpl instance
     */
    public IAMStatsImpl() {
    }

    /**
     * Creates a new IAMStatsImpl instance
     *
     * @param that DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    protected IAMStatsImpl(IUnknownImpl that) throws ComException {
        super(that);
    }

    /**
     * Creates a new IAMStatsImpl instance
     *
     * @param that DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public IAMStatsImpl(IUnknown that) throws ComException {
        super(that);
    }

    /**
     * Creates a new IAMStatsImpl instance
     *
     * @param clsid DOCUMENT ME!
     * @param dwClsContext DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public IAMStatsImpl(CLSID clsid, ClsCtx dwClsContext)
        throws ComException {
        super(clsid, dwClsContext);
    }

    /**
     * Creates a new IAMStatsImpl instance
     *
     * @param clsid DOCUMENT ME!
     * @param pUnkOuter DOCUMENT ME!
     * @param dwClsContext DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public IAMStatsImpl(CLSID clsid, IUnknownImpl pUnkOuter, ClsCtx dwClsContext)
        throws ComException {
        super(clsid, pUnkOuter, dwClsContext);
    }

    /**
     * DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public void reset() throws ComException {
        invokeStandardVirtualMethod(7, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[0]);
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public Int32 getCount() throws ComException {
        Int32 plCount = new Int32();
        invokeStandardVirtualMethod(8, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                (plCount == null) ? (Parameter) PTR_NULL
                                  : new Pointer.OutOnly(plCount)
            });

        return plCount;
    }

    /**
     * DOCUMENT ME!
     *
     * @param lIndex DOCUMENT ME!
     * @param szName DOCUMENT ME!
     * @param lCount DOCUMENT ME!
     * @param dLast DOCUMENT ME!
     * @param dAverage DOCUMENT ME!
     * @param dStdDev DOCUMENT ME!
     * @param dMin DOCUMENT ME!
     * @param dMax DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public void getValueByIndex(Int32 /*[in]*/ lIndex, BStr /*[out]*/ szName,
        Int32 /*[out]*/ lCount, DoubleFloat /*[out]*/ dLast,
        DoubleFloat /*[out]*/ dAverage, DoubleFloat /*[out]*/ dStdDev,
        DoubleFloat /*[out]*/ dMin, DoubleFloat /*[out]*/ dMax)
        throws ComException {
        invokeStandardVirtualMethod(9, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                lIndex,
                (szName == null) ? (Parameter) PTR_NULL
                                 : new Pointer.OutOnly(szName),
                (lCount == null) ? (Parameter) PTR_NULL
                                 : new Pointer.OutOnly(lCount),
                (dLast == null) ? (Parameter) PTR_NULL
                                : new Pointer.OutOnly(dLast),
                (dAverage == null) ? (Parameter) PTR_NULL
                                   : new Pointer.OutOnly(dAverage),
                (dStdDev == null) ? (Parameter) PTR_NULL
                                  : new Pointer.OutOnly(dStdDev),
                (dMin == null) ? (Parameter) PTR_NULL : new Pointer.OutOnly(
                    dMin),
                (dMax == null) ? (Parameter) PTR_NULL : new Pointer.OutOnly(
                    dMax)
            });
    }

    /**
     * DOCUMENT ME!
     *
     * @param szName DOCUMENT ME!
     * @param lIndex DOCUMENT ME!
     * @param lCount DOCUMENT ME!
     * @param dLast DOCUMENT ME!
     * @param dAverage DOCUMENT ME!
     * @param dStdDev DOCUMENT ME!
     * @param dMin DOCUMENT ME!
     * @param dMax DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public void getValueByName(BStr /*[in]*/ szName, Int32 /*[out]*/ lIndex,
        Int32 /*[out]*/ lCount, DoubleFloat /*[out]*/ dLast,
        DoubleFloat /*[out]*/ dAverage, DoubleFloat /*[out]*/ dStdDev,
        DoubleFloat /*[out]*/ dMin, DoubleFloat /*[out]*/ dMax)
        throws ComException {
        invokeStandardVirtualMethod(10, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                (szName == null) ? (Parameter) PTR_NULL : new Const(szName),
                (lIndex == null) ? (Parameter) PTR_NULL
                                 : new Pointer.OutOnly(lIndex),
                (lCount == null) ? (Parameter) PTR_NULL
                                 : new Pointer.OutOnly(lCount),
                (dLast == null) ? (Parameter) PTR_NULL
                                : new Pointer.OutOnly(dLast),
                (dAverage == null) ? (Parameter) PTR_NULL
                                   : new Pointer.OutOnly(dAverage),
                (dStdDev == null) ? (Parameter) PTR_NULL
                                  : new Pointer.OutOnly(dStdDev),
                (dMin == null) ? (Parameter) PTR_NULL : new Pointer.OutOnly(
                    dMin),
                (dMax == null) ? (Parameter) PTR_NULL : new Pointer.OutOnly(
                    dMax)
            });
    }

    /**
     * DOCUMENT ME!
     *
     * @param szName DOCUMENT ME!
     * @param lCreate DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public Int32 getIndex(BStr /*[in]*/ szName, Int32 /*[in]*/ lCreate)
        throws ComException {
        Int32 plIndex = new Int32();
        invokeStandardVirtualMethod(11, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                (szName == null) ? (Parameter) PTR_NULL : new Const(szName),
                lCreate,
                (plIndex == null) ? (Parameter) PTR_NULL
                                  : new Pointer.OutOnly(plIndex)
            });

        return plIndex;
    }

    /**
     * DOCUMENT ME!
     *
     * @param lIndex DOCUMENT ME!
     * @param dValue DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public void addValue(Int32 /*[in]*/ lIndex, DoubleFloat /*[in]*/ dValue)
        throws ComException {
        invokeStandardVirtualMethod(12, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] { lIndex, dValue });
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public IID getIID() {
        return _iid;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public Object clone() {
        IAMStatsImpl that = null;

        try {
            that = new IAMStatsImpl(this);
        } catch (ComException e) {
        }

        return that;
    }
}
