/*
 * File:     IBasicVideoImpl.java
 * Project:  MPI Linguistic Application
 * Date:     12 December 2007
 *
 * Copyright (C) 2001-2008  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.nativemedia.quartztypelib.impl;

import com.jniwrapper.*;

import com.jniwrapper.win32.*;

import com.jniwrapper.win32.automation.*;

import com.jniwrapper.win32.automation.impl.*;

import com.jniwrapper.win32.automation.types.*;

import com.jniwrapper.win32.com.*;

import com.jniwrapper.win32.com.impl.*;

import com.jniwrapper.win32.com.types.*;

import mpi.eudico.client.annotator.nativemedia.quartztypelib.*;


/**
 * Represents COM interface IBasicVideo
 */
public class IBasicVideoImpl extends IDispatchImpl implements IBasicVideo {
    /** Holds value of property DOCUMENT ME! */
    public static final String INTERFACE_IDENTIFIER = IBasicVideo.INTERFACE_IDENTIFIER;

    /** Holds value of property DOCUMENT ME! */
    private static final IID _iid = IID.create(INTERFACE_IDENTIFIER);

    /**
     * Creates a new IBasicVideoImpl instance
     */
    public IBasicVideoImpl() {
    }

    /**
     * Creates a new IBasicVideoImpl instance
     *
     * @param that DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    protected IBasicVideoImpl(IUnknownImpl that) throws ComException {
        super(that);
    }

    /**
     * Creates a new IBasicVideoImpl instance
     *
     * @param that DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public IBasicVideoImpl(IUnknown that) throws ComException {
        super(that);
    }

    /**
     * Creates a new IBasicVideoImpl instance
     *
     * @param clsid DOCUMENT ME!
     * @param dwClsContext DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public IBasicVideoImpl(CLSID clsid, ClsCtx dwClsContext)
        throws ComException {
        super(clsid, dwClsContext);
    }

    /**
     * Creates a new IBasicVideoImpl instance
     *
     * @param clsid DOCUMENT ME!
     * @param pUnkOuter DOCUMENT ME!
     * @param dwClsContext DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public IBasicVideoImpl(CLSID clsid, IUnknownImpl pUnkOuter,
        ClsCtx dwClsContext) throws ComException {
        super(clsid, pUnkOuter, dwClsContext);
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public DoubleFloat getAvgTimePerFrame() throws ComException {
        DoubleFloat pAvgTimePerFrame = new DoubleFloat();
        invokeStandardVirtualMethod(7, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                (pAvgTimePerFrame == null) ? (Parameter) PTR_NULL
                                           : new Pointer.OutOnly(
                    pAvgTimePerFrame)
            });

        return pAvgTimePerFrame;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public Int32 getBitRate() throws ComException {
        Int32 pBitRate = new Int32();
        invokeStandardVirtualMethod(8, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                (pBitRate == null) ? (Parameter) PTR_NULL
                                   : new Pointer.OutOnly(pBitRate)
            });

        return pBitRate;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public Int32 getBitErrorRate() throws ComException {
        Int32 pBitErrorRate = new Int32();
        invokeStandardVirtualMethod(9, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                (pBitErrorRate == null) ? (Parameter) PTR_NULL
                                        : new Pointer.OutOnly(pBitErrorRate)
            });

        return pBitErrorRate;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public Int32 getVideoWidth() throws ComException {
        Int32 pVideoWidth = new Int32();
        invokeStandardVirtualMethod(10, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                (pVideoWidth == null) ? (Parameter) PTR_NULL
                                      : new Pointer.OutOnly(pVideoWidth)
            });

        return pVideoWidth;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public Int32 getVideoHeight() throws ComException {
        Int32 pVideoHeight = new Int32();
        invokeStandardVirtualMethod(11, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                (pVideoHeight == null) ? (Parameter) PTR_NULL
                                       : new Pointer.OutOnly(pVideoHeight)
            });

        return pVideoHeight;
    }

    /**
     * DOCUMENT ME!
     *
     * @param pSourceLeft DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public void setSourceLeft(Int32 /*[in]*/ pSourceLeft)
        throws ComException {
        invokeStandardVirtualMethod(12, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] { pSourceLeft });
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public Int32 getSourceLeft() throws ComException {
        Int32 pSourceLeft = new Int32();
        invokeStandardVirtualMethod(13, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                (pSourceLeft == null) ? (Parameter) PTR_NULL
                                      : new Pointer.OutOnly(pSourceLeft)
            });

        return pSourceLeft;
    }

    /**
     * DOCUMENT ME!
     *
     * @param pSourceWidth DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public void setSourceWidth(Int32 /*[in]*/ pSourceWidth)
        throws ComException {
        invokeStandardVirtualMethod(14, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] { pSourceWidth });
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public Int32 getSourceWidth() throws ComException {
        Int32 pSourceWidth = new Int32();
        invokeStandardVirtualMethod(15, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                (pSourceWidth == null) ? (Parameter) PTR_NULL
                                       : new Pointer.OutOnly(pSourceWidth)
            });

        return pSourceWidth;
    }

    /**
     * DOCUMENT ME!
     *
     * @param pSourceTop DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public void setSourceTop(Int32 /*[in]*/ pSourceTop)
        throws ComException {
        invokeStandardVirtualMethod(16, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] { pSourceTop });
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public Int32 getSourceTop() throws ComException {
        Int32 pSourceTop = new Int32();
        invokeStandardVirtualMethod(17, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                (pSourceTop == null) ? (Parameter) PTR_NULL
                                     : new Pointer.OutOnly(pSourceTop)
            });

        return pSourceTop;
    }

    /**
     * DOCUMENT ME!
     *
     * @param pSourceHeight DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public void setSourceHeight(Int32 /*[in]*/ pSourceHeight)
        throws ComException {
        invokeStandardVirtualMethod(18, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] { pSourceHeight });
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public Int32 getSourceHeight() throws ComException {
        Int32 pSourceHeight = new Int32();
        invokeStandardVirtualMethod(19, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                (pSourceHeight == null) ? (Parameter) PTR_NULL
                                        : new Pointer.OutOnly(pSourceHeight)
            });

        return pSourceHeight;
    }

    /**
     * DOCUMENT ME!
     *
     * @param pDestinationLeft DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public void setDestinationLeft(Int32 /*[in]*/ pDestinationLeft)
        throws ComException {
        invokeStandardVirtualMethod(20, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] { pDestinationLeft });
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public Int32 getDestinationLeft() throws ComException {
        Int32 pDestinationLeft = new Int32();
        invokeStandardVirtualMethod(21, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                (pDestinationLeft == null) ? (Parameter) PTR_NULL
                                           : new Pointer.OutOnly(
                    pDestinationLeft)
            });

        return pDestinationLeft;
    }

    /**
     * DOCUMENT ME!
     *
     * @param pDestinationWidth DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public void setDestinationWidth(Int32 /*[in]*/ pDestinationWidth)
        throws ComException {
        invokeStandardVirtualMethod(22, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] { pDestinationWidth });
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public Int32 getDestinationWidth() throws ComException {
        Int32 pDestinationWidth = new Int32();
        invokeStandardVirtualMethod(23, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                (pDestinationWidth == null) ? (Parameter) PTR_NULL
                                            : new Pointer.OutOnly(
                    pDestinationWidth)
            });

        return pDestinationWidth;
    }

    /**
     * DOCUMENT ME!
     *
     * @param pDestinationTop DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public void setDestinationTop(Int32 /*[in]*/ pDestinationTop)
        throws ComException {
        invokeStandardVirtualMethod(24, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] { pDestinationTop });
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public Int32 getDestinationTop() throws ComException {
        Int32 pDestinationTop = new Int32();
        invokeStandardVirtualMethod(25, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                (pDestinationTop == null) ? (Parameter) PTR_NULL
                                          : new Pointer.OutOnly(pDestinationTop)
            });

        return pDestinationTop;
    }

    /**
     * DOCUMENT ME!
     *
     * @param pDestinationHeight DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public void setDestinationHeight(Int32 /*[in]*/ pDestinationHeight)
        throws ComException {
        invokeStandardVirtualMethod(26, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] { pDestinationHeight });
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public Int32 getDestinationHeight() throws ComException {
        Int32 pDestinationHeight = new Int32();
        invokeStandardVirtualMethod(27, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                (pDestinationHeight == null) ? (Parameter) PTR_NULL
                                             : new Pointer.OutOnly(
                    pDestinationHeight)
            });

        return pDestinationHeight;
    }

    /**
     * DOCUMENT ME!
     *
     * @param Left DOCUMENT ME!
     * @param Top DOCUMENT ME!
     * @param Width DOCUMENT ME!
     * @param Height DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public void setSourcePosition(Int32 /*[in]*/ Left, Int32 /*[in]*/ Top,
        Int32 /*[in]*/ Width, Int32 /*[in]*/ Height) throws ComException {
        invokeStandardVirtualMethod(28, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] { Left, Top, Width, Height });
    }

    /**
     * DOCUMENT ME!
     *
     * @param pLeft DOCUMENT ME!
     * @param pTop DOCUMENT ME!
     * @param pWidth DOCUMENT ME!
     * @param pHeight DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public void getSourcePosition(Int32 /*[out]*/ pLeft, Int32 /*[out]*/ pTop,
        Int32 /*[out]*/ pWidth, Int32 /*[out]*/ pHeight)
        throws ComException {
        invokeStandardVirtualMethod(29, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                (pLeft == null) ? (Parameter) PTR_NULL
                                : new Pointer.OutOnly(pLeft),
                (pTop == null) ? (Parameter) PTR_NULL : new Pointer.OutOnly(
                    pTop),
                (pWidth == null) ? (Parameter) PTR_NULL
                                 : new Pointer.OutOnly(pWidth),
                (pHeight == null) ? (Parameter) PTR_NULL
                                  : new Pointer.OutOnly(pHeight)
            });
    }

    /**
     * DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public void setDefaultSourcePosition() throws ComException {
        invokeStandardVirtualMethod(30, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[0]);
    }

    /**
     * DOCUMENT ME!
     *
     * @param Left DOCUMENT ME!
     * @param Top DOCUMENT ME!
     * @param Width DOCUMENT ME!
     * @param Height DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public void setDestinationPosition(Int32 /*[in]*/ Left, Int32 /*[in]*/ Top,
        Int32 /*[in]*/ Width, Int32 /*[in]*/ Height) throws ComException {
        invokeStandardVirtualMethod(31, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] { Left, Top, Width, Height });
    }

    /**
     * DOCUMENT ME!
     *
     * @param pLeft DOCUMENT ME!
     * @param pTop DOCUMENT ME!
     * @param pWidth DOCUMENT ME!
     * @param pHeight DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public void getDestinationPosition(Int32 /*[out]*/ pLeft,
        Int32 /*[out]*/ pTop, Int32 /*[out]*/ pWidth, Int32 /*[out]*/ pHeight)
        throws ComException {
        invokeStandardVirtualMethod(32, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                (pLeft == null) ? (Parameter) PTR_NULL
                                : new Pointer.OutOnly(pLeft),
                (pTop == null) ? (Parameter) PTR_NULL : new Pointer.OutOnly(
                    pTop),
                (pWidth == null) ? (Parameter) PTR_NULL
                                 : new Pointer.OutOnly(pWidth),
                (pHeight == null) ? (Parameter) PTR_NULL
                                  : new Pointer.OutOnly(pHeight)
            });
    }

    /**
     * DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public void setDefaultDestinationPosition() throws ComException {
        invokeStandardVirtualMethod(33, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[0]);
    }

    /**
     * DOCUMENT ME!
     *
     * @param pWidth DOCUMENT ME!
     * @param pHeight DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public void getVideoSize(Int32 /*[out]*/ pWidth, Int32 /*[out]*/ pHeight)
        throws ComException {
        invokeStandardVirtualMethod(34, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                (pWidth == null) ? (Parameter) PTR_NULL
                                 : new Pointer.OutOnly(pWidth),
                (pHeight == null) ? (Parameter) PTR_NULL
                                  : new Pointer.OutOnly(pHeight)
            });
    }

    /**
     * DOCUMENT ME!
     *
     * @param StartIndex DOCUMENT ME!
     * @param Entries DOCUMENT ME!
     * @param pRetrieved DOCUMENT ME!
     * @param pPalette DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public void getVideoPaletteEntries(Int32 /*[in]*/ StartIndex,
        Int32 /*[in]*/ Entries, Int32 /*[out]*/ pRetrieved,
        Int32 /*[out]*/ pPalette) throws ComException {
        invokeStandardVirtualMethod(35, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                StartIndex, Entries,
                (pRetrieved == null) ? (Parameter) PTR_NULL
                                     : new Pointer.OutOnly(pRetrieved),
                (pPalette == null) ? (Parameter) PTR_NULL
                                   : new Pointer.OutOnly(pPalette)
            });
    }

    /**
     * DOCUMENT ME!
     *
     * @param pBufferSize DOCUMENT ME!
     * @param pDIBImage DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public void getCurrentImage(Int32 /*[in,out]*/ pBufferSize,
        Int32 /*[out]*/ pDIBImage) throws ComException {
        invokeStandardVirtualMethod(36, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                (pBufferSize == null) ? (Parameter) PTR_NULL
                                      : new Pointer(pBufferSize),
                (pDIBImage == null) ? (Parameter) PTR_NULL
                                    : new Pointer.OutOnly(pDIBImage)
            });
    }

    /**
     * This method has not been created by jniwrapper.
     * Calling getCurrentImage with two valid Int32 objects causes
     * an E_OUTOFMEMORY exception.
     * First call getCurrentImage to get the size of the buffer.
     *
     * @see #getCurrentImage(Int32, Int32)
     *
     * @param p array of size 2: p[0] should be a valid Int32 Pointer,
     * p[1] should be a valid ExternalArrayPointer
     * @throws ComException any ComException
     */
    public void getCurrentImage2(Parameter[] p) throws ComException {
        invokeStandardVirtualMethod(36, Function.STDCALL_CALLING_CONVENTION, p);
    }

    /**
     * DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public void isUsingDefaultSource() throws ComException {
        invokeStandardVirtualMethod(37, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[0]);
    }

    /**
     * DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public void isUsingDefaultDestination() throws ComException {
        invokeStandardVirtualMethod(38, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[0]);
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public IID getIID() {
        return _iid;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public Object clone() {
        IBasicVideoImpl that = null;

        try {
            that = new IBasicVideoImpl(this);
        } catch (ComException e) {
        }

        return that;
    }
}
