/*
 * File:     IDeferredCommandImpl.java
 * Project:  MPI Linguistic Application
 * Date:     12 December 2007
 *
 * Copyright (C) 2001-2008  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.nativemedia.quartztypelib.impl;

import com.jniwrapper.*;

import com.jniwrapper.win32.*;

import com.jniwrapper.win32.com.*;

import com.jniwrapper.win32.com.impl.*;

import com.jniwrapper.win32.com.types.*;

import mpi.eudico.client.annotator.nativemedia.quartztypelib.*;


/**
 * Represents COM interface IDeferredCommand
 */
public class IDeferredCommandImpl extends IUnknownImpl
    implements IDeferredCommand {
    /** Holds value of property DOCUMENT ME! */
    public static final String INTERFACE_IDENTIFIER = IDeferredCommand.INTERFACE_IDENTIFIER;

    /** Holds value of property DOCUMENT ME! */
    private static final IID _iid = IID.create(INTERFACE_IDENTIFIER);

    /**
     * Creates a new IDeferredCommandImpl instance
     */
    public IDeferredCommandImpl() {
    }

    /**
     * Creates a new IDeferredCommandImpl instance
     *
     * @param that DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    protected IDeferredCommandImpl(IUnknownImpl that) throws ComException {
        super(that);
    }

    /**
     * Creates a new IDeferredCommandImpl instance
     *
     * @param that DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public IDeferredCommandImpl(IUnknown that) throws ComException {
        super(that);
    }

    /**
     * Creates a new IDeferredCommandImpl instance
     *
     * @param clsid DOCUMENT ME!
     * @param dwClsContext DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public IDeferredCommandImpl(CLSID clsid, ClsCtx dwClsContext)
        throws ComException {
        super(clsid, dwClsContext);
    }

    /**
     * Creates a new IDeferredCommandImpl instance
     *
     * @param clsid DOCUMENT ME!
     * @param pUnkOuter DOCUMENT ME!
     * @param dwClsContext DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public IDeferredCommandImpl(CLSID clsid, IUnknownImpl pUnkOuter,
        ClsCtx dwClsContext) throws ComException {
        super(clsid, pUnkOuter, dwClsContext);
    }

    /**
     * DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public void cancel() throws ComException {
        invokeStandardVirtualMethod(3, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[0]);
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public Int32 confidence() throws ComException {
        Int32 pConfidence = new Int32();
        invokeStandardVirtualMethod(4, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                (pConfidence == null) ? (Parameter) PTR_NULL
                                      : new Pointer.OutOnly(pConfidence)
            });

        return pConfidence;
    }

    /**
     * DOCUMENT ME!
     *
     * @param newtime DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public void postpone(DoubleFloat /*[in]*/ newtime)
        throws ComException {
        invokeStandardVirtualMethod(5, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] { newtime });
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public HResult getHResult() throws ComException {
        HResult phrResult = new HResult();
        invokeStandardVirtualMethod(6, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                (phrResult == null) ? (Parameter) PTR_NULL
                                    : new Pointer.OutOnly(phrResult)
            });

        return phrResult;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public IID getIID() {
        return _iid;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public Object clone() {
        IDeferredCommandImpl that = null;

        try {
            that = new IDeferredCommandImpl(this);
        } catch (ComException e) {
        }

        return that;
    }
}
