/*
 * File:     IFilterInfoImpl.java
 * Project:  MPI Linguistic Application
 * Date:     12 December 2007
 *
 * Copyright (C) 2001-2008  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.nativemedia.quartztypelib.impl;

import com.jniwrapper.*;

import com.jniwrapper.win32.*;

import com.jniwrapper.win32.automation.*;

import com.jniwrapper.win32.automation.impl.*;

import com.jniwrapper.win32.automation.types.*;

import com.jniwrapper.win32.com.*;

import com.jniwrapper.win32.com.impl.*;

import com.jniwrapper.win32.com.types.*;

import mpi.eudico.client.annotator.nativemedia.quartztypelib.*;


/**
 * Represents COM interface IFilterInfo
 */
public class IFilterInfoImpl extends IDispatchImpl implements IFilterInfo {
    /** Holds value of property DOCUMENT ME! */
    public static final String INTERFACE_IDENTIFIER = IFilterInfo.INTERFACE_IDENTIFIER;

    /** Holds value of property DOCUMENT ME! */
    private static final IID _iid = IID.create(INTERFACE_IDENTIFIER);

    /**
     * Creates a new IFilterInfoImpl instance
     */
    public IFilterInfoImpl() {
    }

    /**
     * Creates a new IFilterInfoImpl instance
     *
     * @param that DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    protected IFilterInfoImpl(IUnknownImpl that) throws ComException {
        super(that);
    }

    /**
     * Creates a new IFilterInfoImpl instance
     *
     * @param that DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public IFilterInfoImpl(IUnknown that) throws ComException {
        super(that);
    }

    /**
     * Creates a new IFilterInfoImpl instance
     *
     * @param clsid DOCUMENT ME!
     * @param dwClsContext DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public IFilterInfoImpl(CLSID clsid, ClsCtx dwClsContext)
        throws ComException {
        super(clsid, dwClsContext);
    }

    /**
     * Creates a new IFilterInfoImpl instance
     *
     * @param clsid DOCUMENT ME!
     * @param pUnkOuter DOCUMENT ME!
     * @param dwClsContext DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public IFilterInfoImpl(CLSID clsid, IUnknownImpl pUnkOuter,
        ClsCtx dwClsContext) throws ComException {
        super(clsid, pUnkOuter, dwClsContext);
    }

    /**
     * DOCUMENT ME!
     *
     * @param strPinID DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public IDispatch findPin(BStr /*[in]*/ strPinID) throws ComException {
        IDispatchImpl ppUnk = new IDispatchImpl();
        invokeStandardVirtualMethod(7, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                (strPinID == null) ? (Parameter) PTR_NULL : new Const(strPinID),
                (ppUnk == null) ? (Parameter) PTR_NULL
                                : new Pointer.OutOnly((Parameter) ppUnk)
            });

        return ppUnk;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public BStr getName() throws ComException {
        BStr strName = new BStr();
        invokeStandardVirtualMethod(8, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                (strName == null) ? (Parameter) PTR_NULL
                                  : new Pointer.OutOnly(strName)
            });

        return strName;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public BStr getVendorInfo() throws ComException {
        BStr strVendorInfo = new BStr();
        invokeStandardVirtualMethod(9, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                (strVendorInfo == null) ? (Parameter) PTR_NULL
                                        : new Pointer.OutOnly(strVendorInfo)
            });

        return strVendorInfo;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public IUnknown getFilter() throws ComException {
        IUnknownImpl ppUnk = new IUnknownImpl();
        invokeStandardVirtualMethod(10, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                (ppUnk == null) ? (Parameter) PTR_NULL
                                : new Pointer.OutOnly((Parameter) ppUnk)
            });

        return ppUnk;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public IDispatch getPins() throws ComException {
        IDispatchImpl ppUnk = new IDispatchImpl();
        invokeStandardVirtualMethod(11, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                (ppUnk == null) ? (Parameter) PTR_NULL
                                : new Pointer.OutOnly((Parameter) ppUnk)
            });

        return ppUnk;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public Int32 getIsFileSource() throws ComException {
        Int32 pbIsSource = new Int32();
        invokeStandardVirtualMethod(12, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                (pbIsSource == null) ? (Parameter) PTR_NULL
                                     : new Pointer.OutOnly(pbIsSource)
            });

        return pbIsSource;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public BStr getFilename() throws ComException {
        BStr pstrFilename = new BStr();
        invokeStandardVirtualMethod(13, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                (pstrFilename == null) ? (Parameter) PTR_NULL
                                       : new Pointer.OutOnly(pstrFilename)
            });

        return pstrFilename;
    }

    /**
     * DOCUMENT ME!
     *
     * @param pstrFilename DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public void setFilename(BStr /*[in]*/ pstrFilename)
        throws ComException {
        invokeStandardVirtualMethod(14, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                (pstrFilename == null) ? (Parameter) PTR_NULL
                                       : new Const(pstrFilename)
            });
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public IID getIID() {
        return _iid;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public Object clone() {
        IFilterInfoImpl that = null;

        try {
            that = new IFilterInfoImpl(this);
        } catch (ComException e) {
        }

        return that;
    }
}
