/*
 * File:     IMediaControlImpl.java
 * Project:  MPI Linguistic Application
 * Date:     12 December 2007
 *
 * Copyright (C) 2001-2008  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.nativemedia.quartztypelib.impl;

import com.jniwrapper.*;

import com.jniwrapper.win32.*;

import com.jniwrapper.win32.automation.*;

import com.jniwrapper.win32.automation.impl.*;

import com.jniwrapper.win32.automation.types.*;

import com.jniwrapper.win32.com.*;

import com.jniwrapper.win32.com.impl.*;

import com.jniwrapper.win32.com.types.*;

import mpi.eudico.client.annotator.nativemedia.quartztypelib.*;


/**
 * Represents COM interface IMediaControl
 */
public class IMediaControlImpl extends IDispatchImpl implements IMediaControl {
    /** Holds value of property DOCUMENT ME! */
    public static final String INTERFACE_IDENTIFIER = IMediaControl.INTERFACE_IDENTIFIER;

    /** Holds value of property DOCUMENT ME! */
    private static final IID _iid = IID.create(INTERFACE_IDENTIFIER);

    /**
     * Creates a new IMediaControlImpl instance
     */
    public IMediaControlImpl() {
    }

    /**
     * Creates a new IMediaControlImpl instance
     *
     * @param that DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    protected IMediaControlImpl(IUnknownImpl that) throws ComException {
        super(that);
    }

    /**
     * Creates a new IMediaControlImpl instance
     *
     * @param that DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public IMediaControlImpl(IUnknown that) throws ComException {
        super(that);
    }

    /**
     * Creates a new IMediaControlImpl instance
     *
     * @param clsid DOCUMENT ME!
     * @param dwClsContext DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public IMediaControlImpl(CLSID clsid, ClsCtx dwClsContext)
        throws ComException {
        super(clsid, dwClsContext);
    }

    /**
     * Creates a new IMediaControlImpl instance
     *
     * @param clsid DOCUMENT ME!
     * @param pUnkOuter DOCUMENT ME!
     * @param dwClsContext DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public IMediaControlImpl(CLSID clsid, IUnknownImpl pUnkOuter,
        ClsCtx dwClsContext) throws ComException {
        super(clsid, pUnkOuter, dwClsContext);
    }

    /**
     * DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public void run() throws ComException {
        invokeStandardVirtualMethod(7, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[0]);
    }

    /**
     * DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public void pause() throws ComException {
        invokeStandardVirtualMethod(8, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[0]);
    }

    /**
     * DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public void stop() throws ComException {
        invokeStandardVirtualMethod(9, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[0]);
    }

    /**
     * DOCUMENT ME!
     *
     * @param msTimeout DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public Int32 getState(Int32 /*[in]*/ msTimeout) throws ComException {
        Int32 pfs = new Int32();
        invokeStandardVirtualMethod(10, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                msTimeout,
                (pfs == null) ? (Parameter) PTR_NULL : new Pointer.OutOnly(pfs)
            });

        return pfs;
    }

    /**
     * DOCUMENT ME!
     *
     * @param strFilename DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public void renderFile(BStr /*[in]*/ strFilename) throws ComException {
        invokeStandardVirtualMethod(11, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                (strFilename == null) ? (Parameter) PTR_NULL
                                      : new Const(strFilename)
            });
    }

    /**
     * DOCUMENT ME!
     *
     * @param strFilename DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public IDispatch addSourceFilter(BStr /*[in]*/ strFilename)
        throws ComException {
        IDispatchImpl ppUnk = new IDispatchImpl();
        invokeStandardVirtualMethod(12, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                (strFilename == null) ? (Parameter) PTR_NULL
                                      : new Const(strFilename),
                (ppUnk == null) ? (Parameter) PTR_NULL
                                : new Pointer.OutOnly((Parameter) ppUnk)
            });

        return ppUnk;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public IDispatch getFilterCollection() throws ComException {
        IDispatchImpl ppUnk = new IDispatchImpl();
        invokeStandardVirtualMethod(13, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                (ppUnk == null) ? (Parameter) PTR_NULL
                                : new Pointer.OutOnly((Parameter) ppUnk)
            });

        return ppUnk;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public IDispatch getRegFilterCollection() throws ComException {
        IDispatchImpl ppUnk = new IDispatchImpl();
        invokeStandardVirtualMethod(14, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                (ppUnk == null) ? (Parameter) PTR_NULL
                                : new Pointer.OutOnly((Parameter) ppUnk)
            });

        return ppUnk;
    }

    /**
     * DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public void stopWhenReady() throws ComException {
        invokeStandardVirtualMethod(15, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[0]);
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public IID getIID() {
        return _iid;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public Object clone() {
        IMediaControlImpl that = null;

        try {
            that = new IMediaControlImpl(this);
        } catch (ComException e) {
        }

        return that;
    }
}
