/*
 * File:     IMediaEventImpl.java
 * Project:  MPI Linguistic Application
 * Date:     12 December 2007
 *
 * Copyright (C) 2001-2008  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.nativemedia.quartztypelib.impl;

import com.jniwrapper.*;

import com.jniwrapper.win32.*;

import com.jniwrapper.win32.automation.*;

import com.jniwrapper.win32.automation.impl.*;

import com.jniwrapper.win32.automation.types.*;

import com.jniwrapper.win32.com.*;

import com.jniwrapper.win32.com.impl.*;

import com.jniwrapper.win32.com.types.*;

import mpi.eudico.client.annotator.nativemedia.quartztypelib.*;


/**
 * Represents COM interface IMediaEvent
 */
public class IMediaEventImpl extends IDispatchImpl implements IMediaEvent {
    /** Holds value of property DOCUMENT ME! */
    public static final String INTERFACE_IDENTIFIER = IMediaEvent.INTERFACE_IDENTIFIER;

    /** Holds value of property DOCUMENT ME! */
    private static final IID _iid = IID.create(INTERFACE_IDENTIFIER);

    /**
     * Creates a new IMediaEventImpl instance
     */
    public IMediaEventImpl() {
    }

    /**
     * Creates a new IMediaEventImpl instance
     *
     * @param that DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    protected IMediaEventImpl(IUnknownImpl that) throws ComException {
        super(that);
    }

    /**
     * Creates a new IMediaEventImpl instance
     *
     * @param that DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public IMediaEventImpl(IUnknown that) throws ComException {
        super(that);
    }

    /**
     * Creates a new IMediaEventImpl instance
     *
     * @param clsid DOCUMENT ME!
     * @param dwClsContext DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public IMediaEventImpl(CLSID clsid, ClsCtx dwClsContext)
        throws ComException {
        super(clsid, dwClsContext);
    }

    /**
     * Creates a new IMediaEventImpl instance
     *
     * @param clsid DOCUMENT ME!
     * @param pUnkOuter DOCUMENT ME!
     * @param dwClsContext DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public IMediaEventImpl(CLSID clsid, IUnknownImpl pUnkOuter,
        ClsCtx dwClsContext) throws ComException {
        super(clsid, pUnkOuter, dwClsContext);
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public LongPtr getEventHandle() throws ComException {
        LongPtr hEvent = new LongPtr();
        invokeStandardVirtualMethod(7, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                (hEvent == null) ? (Parameter) PTR_NULL
                                 : new Pointer.OutOnly(hEvent)
            });

        return hEvent;
    }

    /**
     * DOCUMENT ME!
     *
     * @param lEventCode DOCUMENT ME!
     * @param lParam1 DOCUMENT ME!
     * @param lParam2 DOCUMENT ME!
     * @param msTimeout DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public void getEvent(Int32 /*[out]*/ lEventCode, LongPtr /*[out]*/ lParam1,
        LongPtr /*[out]*/ lParam2, Int32 /*[in]*/ msTimeout)
        throws ComException {
        invokeStandardVirtualMethod(8, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                (lEventCode == null) ? (Parameter) PTR_NULL
                                     : new Pointer.OutOnly(lEventCode),
                (lParam1 == null) ? (Parameter) PTR_NULL
                                  : new Pointer.OutOnly(lParam1),
                (lParam2 == null) ? (Parameter) PTR_NULL
                                  : new Pointer.OutOnly(lParam2), msTimeout
            });
    }

    /**
     * DOCUMENT ME!
     *
     * @param msTimeout DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public Int32 waitForCompletion(Int32 /*[in]*/ msTimeout)
        throws ComException {
        Int32 pEvCode = new Int32();
        invokeStandardVirtualMethod(9, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                msTimeout,
                (pEvCode == null) ? (Parameter) PTR_NULL
                                  : new Pointer.OutOnly(pEvCode)
            });

        return pEvCode;
    }

    /**
     * DOCUMENT ME!
     *
     * @param lEvCode DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public void cancelDefaultHandling(Int32 /*[in]*/ lEvCode)
        throws ComException {
        invokeStandardVirtualMethod(10, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] { lEvCode });
    }

    /**
     * DOCUMENT ME!
     *
     * @param lEvCode DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public void restoreDefaultHandling(Int32 /*[in]*/ lEvCode)
        throws ComException {
        invokeStandardVirtualMethod(11, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] { lEvCode });
    }

    /**
     * DOCUMENT ME!
     *
     * @param lEvCode DOCUMENT ME!
     * @param lParam1 DOCUMENT ME!
     * @param lParam2 DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public void freeEventParams(Int32 /*[in]*/ lEvCode,
        LongPtr /*[in]*/ lParam1, LongPtr /*[in]*/ lParam2)
        throws ComException {
        invokeStandardVirtualMethod(12, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] { lEvCode, lParam1, lParam2 });
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public IID getIID() {
        return _iid;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public Object clone() {
        IMediaEventImpl that = null;

        try {
            that = new IMediaEventImpl(this);
        } catch (ComException e) {
        }

        return that;
    }
}
