/*
 * File:     IMediaPositionImpl.java
 * Project:  MPI Linguistic Application
 * Date:     12 December 2007
 *
 * Copyright (C) 2001-2008  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.nativemedia.quartztypelib.impl;

import com.jniwrapper.*;

import com.jniwrapper.win32.*;

import com.jniwrapper.win32.automation.*;

import com.jniwrapper.win32.automation.impl.*;

import com.jniwrapper.win32.automation.types.*;

import com.jniwrapper.win32.com.*;

import com.jniwrapper.win32.com.impl.*;

import com.jniwrapper.win32.com.types.*;

import mpi.eudico.client.annotator.nativemedia.quartztypelib.*;


/**
 * Represents COM interface IMediaPosition
 */
public class IMediaPositionImpl extends IDispatchImpl implements IMediaPosition {
    /** Holds value of property DOCUMENT ME! */
    public static final String INTERFACE_IDENTIFIER = IMediaPosition.INTERFACE_IDENTIFIER;

    /** Holds value of property DOCUMENT ME! */
    private static final IID _iid = IID.create(INTERFACE_IDENTIFIER);

    /**
     * Creates a new IMediaPositionImpl instance
     */
    public IMediaPositionImpl() {
    }

    /**
     * Creates a new IMediaPositionImpl instance
     *
     * @param that DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    protected IMediaPositionImpl(IUnknownImpl that) throws ComException {
        super(that);
    }

    /**
     * Creates a new IMediaPositionImpl instance
     *
     * @param that DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public IMediaPositionImpl(IUnknown that) throws ComException {
        super(that);
    }

    /**
     * Creates a new IMediaPositionImpl instance
     *
     * @param clsid DOCUMENT ME!
     * @param dwClsContext DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public IMediaPositionImpl(CLSID clsid, ClsCtx dwClsContext)
        throws ComException {
        super(clsid, dwClsContext);
    }

    /**
     * Creates a new IMediaPositionImpl instance
     *
     * @param clsid DOCUMENT ME!
     * @param pUnkOuter DOCUMENT ME!
     * @param dwClsContext DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public IMediaPositionImpl(CLSID clsid, IUnknownImpl pUnkOuter,
        ClsCtx dwClsContext) throws ComException {
        super(clsid, pUnkOuter, dwClsContext);
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public DoubleFloat getDuration() throws ComException {
        DoubleFloat plength = new DoubleFloat();
        invokeStandardVirtualMethod(7, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                (plength == null) ? (Parameter) PTR_NULL
                                  : new Pointer.OutOnly(plength)
            });

        return plength;
    }

    /**
     * DOCUMENT ME!
     *
     * @param pllTime DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public void setCurrentPosition(DoubleFloat /*[in]*/ pllTime)
        throws ComException {
        invokeStandardVirtualMethod(8, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] { pllTime });
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public DoubleFloat getCurrentPosition() throws ComException {
        DoubleFloat pllTime = new DoubleFloat();
        invokeStandardVirtualMethod(9, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                (pllTime == null) ? (Parameter) PTR_NULL
                                  : new Pointer.OutOnly(pllTime)
            });

        return pllTime;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public DoubleFloat getStopTime() throws ComException {
        DoubleFloat pllTime = new DoubleFloat();
        invokeStandardVirtualMethod(10, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                (pllTime == null) ? (Parameter) PTR_NULL
                                  : new Pointer.OutOnly(pllTime)
            });

        return pllTime;
    }

    /**
     * DOCUMENT ME!
     *
     * @param pllTime DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public void setStopTime(DoubleFloat /*[in]*/ pllTime)
        throws ComException {
        invokeStandardVirtualMethod(11, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] { pllTime });
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public DoubleFloat getPrerollTime() throws ComException {
        DoubleFloat pllTime = new DoubleFloat();
        invokeStandardVirtualMethod(12, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                (pllTime == null) ? (Parameter) PTR_NULL
                                  : new Pointer.OutOnly(pllTime)
            });

        return pllTime;
    }

    /**
     * DOCUMENT ME!
     *
     * @param pllTime DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public void setPrerollTime(DoubleFloat /*[in]*/ pllTime)
        throws ComException {
        invokeStandardVirtualMethod(13, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] { pllTime });
    }

    /**
     * DOCUMENT ME!
     *
     * @param pdRate DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public void setRate(DoubleFloat /*[in]*/ pdRate) throws ComException {
        invokeStandardVirtualMethod(14, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] { pdRate });
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public DoubleFloat getRate() throws ComException {
        DoubleFloat pdRate = new DoubleFloat();
        invokeStandardVirtualMethod(15, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                (pdRate == null) ? (Parameter) PTR_NULL
                                 : new Pointer.OutOnly(pdRate)
            });

        return pdRate;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public Int32 canSeekForward() throws ComException {
        Int32 pCanSeekForward = new Int32();
        invokeStandardVirtualMethod(16, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                (pCanSeekForward == null) ? (Parameter) PTR_NULL
                                          : new Pointer.OutOnly(pCanSeekForward)
            });

        return pCanSeekForward;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public Int32 canSeekBackward() throws ComException {
        Int32 pCanSeekBackward = new Int32();
        invokeStandardVirtualMethod(17, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                (pCanSeekBackward == null) ? (Parameter) PTR_NULL
                                           : new Pointer.OutOnly(
                    pCanSeekBackward)
            });

        return pCanSeekBackward;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public IID getIID() {
        return _iid;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public Object clone() {
        IMediaPositionImpl that = null;

        try {
            that = new IMediaPositionImpl(this);
        } catch (ComException e) {
        }

        return that;
    }
}
