/*
 * File:     IMediaTypeInfoImpl.java
 * Project:  MPI Linguistic Application
 * Date:     12 December 2007
 *
 * Copyright (C) 2001-2008  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.nativemedia.quartztypelib.impl;

import com.jniwrapper.*;

import com.jniwrapper.win32.*;

import com.jniwrapper.win32.automation.*;

import com.jniwrapper.win32.automation.impl.*;

import com.jniwrapper.win32.automation.types.*;

import com.jniwrapper.win32.com.*;

import com.jniwrapper.win32.com.impl.*;

import com.jniwrapper.win32.com.types.*;

import mpi.eudico.client.annotator.nativemedia.quartztypelib.*;


/**
 * Represents COM interface IMediaTypeInfo
 */
public class IMediaTypeInfoImpl extends IDispatchImpl implements IMediaTypeInfo {
    /** Holds value of property DOCUMENT ME! */
    public static final String INTERFACE_IDENTIFIER = IMediaTypeInfo.INTERFACE_IDENTIFIER;

    /** Holds value of property DOCUMENT ME! */
    private static final IID _iid = IID.create(INTERFACE_IDENTIFIER);

    /**
     * Creates a new IMediaTypeInfoImpl instance
     */
    public IMediaTypeInfoImpl() {
    }

    /**
     * Creates a new IMediaTypeInfoImpl instance
     *
     * @param that DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    protected IMediaTypeInfoImpl(IUnknownImpl that) throws ComException {
        super(that);
    }

    /**
     * Creates a new IMediaTypeInfoImpl instance
     *
     * @param that DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public IMediaTypeInfoImpl(IUnknown that) throws ComException {
        super(that);
    }

    /**
     * Creates a new IMediaTypeInfoImpl instance
     *
     * @param clsid DOCUMENT ME!
     * @param dwClsContext DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public IMediaTypeInfoImpl(CLSID clsid, ClsCtx dwClsContext)
        throws ComException {
        super(clsid, dwClsContext);
    }

    /**
     * Creates a new IMediaTypeInfoImpl instance
     *
     * @param clsid DOCUMENT ME!
     * @param pUnkOuter DOCUMENT ME!
     * @param dwClsContext DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public IMediaTypeInfoImpl(CLSID clsid, IUnknownImpl pUnkOuter,
        ClsCtx dwClsContext) throws ComException {
        super(clsid, pUnkOuter, dwClsContext);
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public BStr getType() throws ComException {
        BStr strType = new BStr();
        invokeStandardVirtualMethod(7, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                (strType == null) ? (Parameter) PTR_NULL
                                  : new Pointer.OutOnly(strType)
            });

        return strType;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     *
     * @throws ComException DOCUMENT ME!
     */
    public BStr getSubtype() throws ComException {
        BStr strType = new BStr();
        invokeStandardVirtualMethod(8, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                (strType == null) ? (Parameter) PTR_NULL
                                  : new Pointer.OutOnly(strType)
            });

        return strType;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public IID getIID() {
        return _iid;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public Object clone() {
        IMediaTypeInfoImpl that = null;

        try {
            that = new IMediaTypeInfoImpl(this);
        } catch (ComException e) {
        }

        return that;
    }
}
