/*
 * File:     IMediaControlVTBL.java
 * Project:  MPI Linguistic Application
 * Date:     12 December 2007
 *
 * Copyright (C) 2001-2008  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.nativemedia.quartztypelib.server;

import com.jniwrapper.*;

import com.jniwrapper.win32.*;

import com.jniwrapper.win32.automation.*;

import com.jniwrapper.win32.automation.impl.*;

import com.jniwrapper.win32.automation.server.*;

import com.jniwrapper.win32.automation.types.*;

import com.jniwrapper.win32.com.*;

import com.jniwrapper.win32.com.impl.*;

import com.jniwrapper.win32.com.server.*;

import com.jniwrapper.win32.com.types.*;

import mpi.eudico.client.annotator.nativemedia.quartztypelib.*;
import mpi.eudico.client.annotator.nativemedia.quartztypelib.impl.*;


/**
 * Represents VTBL for COM interface IMediaControl
 */
public class IMediaControlVTBL extends IDispatchVTBL {
    /**
     * Creates a new IMediaControlVTBL instance
     *
     * @param classMetaInfo DOCUMENT ME!
     */
    public IMediaControlVTBL(CoClassMetaInfo classMetaInfo) {
        super(classMetaInfo);

        addMembers(new VirtualMethodCallback[] {
                new VirtualMethodCallback("run", new HResult(),
                    new Parameter[] {  }),
                new VirtualMethodCallback("pause", new HResult(),
                    new Parameter[] {  }),
                new VirtualMethodCallback("stop", new HResult(),
                    new Parameter[] {  }),
                new VirtualMethodCallback("getState", new HResult(),
                    new Parameter[] {
                        new Int32(), new Pointer.OutOnly(new Int32())
                    }, 1),
                new VirtualMethodCallback("renderFile", new HResult(),
                    new Parameter[] { new BStr() }),
                new VirtualMethodCallback("addSourceFilter", new HResult(),
                    new Parameter[] {
                        new BStr(), new Pointer.OutOnly(new IDispatchImpl())
                    }, 1),
                new VirtualMethodCallback("getFilterCollection", new HResult(),
                    new Parameter[] { new Pointer.OutOnly(new IDispatchImpl()) },
                    0),
                new VirtualMethodCallback("getRegFilterCollection",
                    new HResult(),
                    new Parameter[] { new Pointer.OutOnly(new IDispatchImpl()) },
                    0),
                new VirtualMethodCallback("stopWhenReady", new HResult(),
                    new Parameter[] {  })
            });
    }
}
