/*
 * File:     IQueueCommandVTBL.java
 * Project:  MPI Linguistic Application
 * Date:     12 December 2007
 *
 * Copyright (C) 2001-2008  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.nativemedia.quartztypelib.server;

import com.jniwrapper.*;

import com.jniwrapper.win32.*;

import com.jniwrapper.win32.automation.types.*;

import com.jniwrapper.win32.com.*;

import com.jniwrapper.win32.com.impl.*;

import com.jniwrapper.win32.com.server.*;

import com.jniwrapper.win32.com.types.*;

import mpi.eudico.client.annotator.nativemedia.quartztypelib.*;
import mpi.eudico.client.annotator.nativemedia.quartztypelib.impl.*;


/**
 * Represents VTBL for COM interface IQueueCommand
 */
public class IQueueCommandVTBL extends IUnknownVTBL {
    /**
     * Creates a new IQueueCommandVTBL instance
     *
     * @param classMetaInfo DOCUMENT ME!
     */
    public IQueueCommandVTBL(CoClassMetaInfo classMetaInfo) {
        super(classMetaInfo);

        addMembers(new VirtualMethodCallback[] {
                new VirtualMethodCallback("invokeAtStreamTime", new HResult(),
                    new Parameter[] {
                        new Pointer.OutOnly(new IDeferredCommandImpl()),
                        new DoubleFloat(), new Pointer.Const(new GUID()),
                        new Int32(), new Int16(), new Int32(),
                        new Pointer.Const(new Variant()),
                        new Pointer(new Variant()),
                        new Pointer.OutOnly(new Int16())
                    }),
                new VirtualMethodCallback("invokeAtPresentationTime",
                    new HResult(),
                    new Parameter[] {
                        new Pointer.OutOnly(new IDeferredCommandImpl()),
                        new DoubleFloat(), new Pointer.Const(new GUID()),
                        new Int32(), new Int16(), new Int32(),
                        new Pointer.Const(new Variant()),
                        new Pointer(new Variant()),
                        new Pointer.OutOnly(new Int16())
                    })
            });
    }
}
