/*
 * File:     ActiveAnnotation.java
 * Project:  MPI Linguistic Application
 * Date:     12 December 2007
 *
 * Copyright (C) 2001-2008  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator;

import mpi.eudico.server.corpora.clom.Annotation;

import java.util.Vector;


/**
 * Administrates the current ActiveAnnotation.
 */
public class ActiveAnnotation {
    private Vector listeners;
    private Annotation annotation;

    /**
     * Creates an empty Cursor.
     */
    public ActiveAnnotation() {
        listeners = new Vector();
        annotation = null;
    }

    /**
     * Sets the Annotation
     *
     * @param annotation DOCUMENT ME!
     */
    public void setAnnotation(Annotation annotation) {
        this.annotation = annotation;

        // Tell all the interested ActiveAnnotation about the change
        notifyListeners();
    }

    /**
     * Gets the Annotation
     *
     * @return DOCUMENT ME!
     */
    public Annotation getAnnotation() {
        return annotation;
    }

    /**
     * Tell all ActiveAnnotationListeners about a change in the
     * ActiveAnnotation
     */
    public void notifyListeners() {
        for (int i = 0; i < listeners.size(); i++) {
            ((ActiveAnnotationListener) listeners.elementAt(i)).updateActiveAnnotation();
        }
    }

    /**
     * Add a listener for ActiveAnnotation events.
     *
     * @param listener the listener that wants to be notified for
     *        ActiveAnnotation events.
     */
    public void addActiveAnnotationListener(ActiveAnnotationListener listener) {
        listeners.add(listener);
        listener.updateActiveAnnotation();
    }

    /**
     * Remove a listener for ActiveAnnotation events.
     *
     * @param listener the listener that no longer wants to be notified for
     *        ActiveAnnotation events.
     */
    public void removeActiveAnnotationListener(
        ActiveAnnotationListener listener) {
        listeners.remove(listener);
    }
}
