/*
 * File:     DetachedViewerFrame.java
 * Project:  MPI Linguistic Application
 * Date:     12 December 2007
 *
 * Copyright (C) 2001-2008  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ComponentEvent;


/**
 * A dialog/frame for detached viewers. The frame will always be on top.
 *
 * @author Han Sloetjes
 */
public class DetachedViewerFrame extends DetachedFrame {
    /**
     * Constructor. Sets a BorderLayout for the contentpane and adds the
     * viewer.
     *
     * @param layoutManager the ElanLayoutManager
     * @param component the viewer
     * @param title the title for the viewer
     */
    public DetachedViewerFrame(ElanLayoutManager layoutManager,
        Component component, String title) {
        super(layoutManager, component, title);

        getContentPane().removeAll();
        getContentPane().setLayout(new BorderLayout());
        getContentPane().add(component);
    }

    /**
     * Override the superclass implementation: the layout manager will handle
     * the resizing of the component.
     *
     * @param e the component event!
     */
    public void componentResized(ComponentEvent e) {
    }
}
