/*
 * File:     DurationPanel.java
 * Project:  MPI Linguistic Application
 * Date:     12 December 2007
 *
 * Copyright (C) 2001-2008  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator;

import mpi.util.TimeFormatter;

import javax.swing.JLabel;


/**
 * DOCUMENT ME!
 * $Id: DurationPanel.java 6047 2006-04-20 10:01:19Z klasal $
 * @author $Author$
 * @version $Revision$
 */
public class DurationPanel extends JLabel {
    /**
     * Creates a new DurationPanel instance
     *
     * @param duration DOCUMENT ME!
     */
    public DurationPanel(long duration) {
        super(TimeFormatter.toString(duration)); //0 doesn't matter because player isn't set yet (see ViewerManager)
        setFont(Constants.SMALLFONT);
    }
}
