/*
 * File:     ELAN.java
 * Project:  MPI Linguistic Application
 * Date:     12 December 2007
 *
 * Copyright (C) 2001-2008  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator;

import mpi.eudico.client.annotator.util.ClientLogger;

import java.awt.EventQueue;

import java.io.File;


/**
 * The main class for ELAN. Main performs some initialization and creates the
 * first frame. Holds version information, major, minor and micro.
 */
public class ELAN implements ClientLogger {
    /** the major version value */
    public static int major = 3;

    /** the minor version value */
    public static int minor = 3;

    /** the micro (bug fix) version value */
    public static int micro = 0;

    /**
     * Creates a new ELAN instance
     */
    private ELAN() {
    }

    /**
     * Main method, initialization and first frame.
     *
     * @param args the arguments
     */
    public static void main(final String[] args) {
        LOG.info("ELAN " + getVersionString());
        LOG.info("Java version: " + System.getProperty("java.version"));
        LOG.info("Runtime version: " +
            System.getProperty("java.runtime.version"));
        LOG.info("OS name: " + System.getProperty("os.name"));
        LOG.info("OS version: " + System.getProperty("os.version"));
        LOG.info("User language: " + System.getProperty("user.language"));

        // webstart initialisation
        mpi.eudico.client.annotator.util.SystemInstallationSecurity.Instance()
                                                                   .go();

        // make sure the directory for Elan data exists, could move to preferences?
        try {
            File dataDir = new File(Constants.ELAN_DATA_DIR);

            if (!dataDir.exists()) {
                dataDir.mkdir();
            }

            // temporary, clean up old crap
            File oldCrap = new File(Constants.STRPROPERTIESFILE);
            oldCrap.delete();
            oldCrap = new File(Constants.USERHOME + Constants.FILESEPARATOR +
                    ".elan.pfs");
            oldCrap.delete();
        } catch (Exception ex) {
            // catch any
        }

        FrameManager.getInstance().setExitAllowed(true);

        // create the frame on the event dispatch thread
        if ((args != null) && (args.length > 0) && (args[0].length() != 0)) {
            EventQueue.invokeLater(new Runnable() {
                    public void run() {
                        FrameManager.getInstance().createFrame(args[0]);
                    }
                });
        } else {
            EventQueue.invokeLater(new Runnable() {
                    public void run() {
                        FrameManager.getInstance().createEmptyFrame();
                    }
                });
        }

        // external launcher, currently only accepts imdi files to open an eaf
        // from another application/VM
        mpi.eudico.client.annotator.integration.ExternalLauncher.start();
    }

    /**
     * Returns the current version information as a string.
     *
     * @return the current version
     */
    public static String getVersionString() {
        return major + "." + minor + "." + micro;
    }
}
