/*
 * File:     AddTierDlgCA.java
 * Project:  MPI Linguistic Application
 * Date:     12 December 2007
 *
 * Copyright (C) 2001-2008  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.commands;

import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.ViewerManager2;

import mpi.eudico.client.annotator.gui.EditTierDialog2;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;

import javax.swing.Action;
import javax.swing.KeyStroke;


/**
 * DOCUMENT ME!
 * $Id: AddTierDlgCA.java 7409 2006-11-30 08:32:54Z hasloe $
 * @author $Author$
 * @version $Revision$
 */
public class AddTierDlgCA extends CommandAction {
    /**
     * Creates a new AddTierDlgCA instance
     *
     * @param theVM the viewer manager
     */
    public AddTierDlgCA(ViewerManager2 theVM) {
        super(theVM, ELANCommandFactory.ADD_TIER);
        putValue(Action.ACCELERATOR_KEY,
            KeyStroke.getKeyStroke(KeyEvent.VK_T,
                Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        putValue(SHORT_DESCRIPTION,
            ElanLocale.getString(ELANCommandFactory.ADD_TIER + "ToolTip"));
    }

    /**
     * Creates a new edit tiers dialog command
     */
    protected void newCommand() {
        command = ELANCommandFactory.createCommand(vm.getTranscription(),
                ELANCommandFactory.EDIT_TIER);
    }

    /**
     * Returns the transcription
     *
     * @return the transcription
     */
    protected Object getReceiver() {
        return vm.getTranscription();
    }

    /**
     * Returns the arguments, here the Add mode constant
     *
     * @return the arguments
     */
    protected Object[] getArguments() {
        Object[] args = new Object[2];
        args[0] = new Integer(EditTierDialog2.ADD);
        args[1] = null;

        return args;
    }
}
