/*
 * File:     AnnotationModeCA.java
 * Project:  MPI Linguistic Application
 * Date:     12 December 2007
 *
 * Copyright (C) 2001-2008  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.commands;

import mpi.eudico.client.annotator.ElanLayoutManager;
import mpi.eudico.client.annotator.ViewerManager2;


/**
 * A command action that switches the application to annotation mode. This is
 * the default mode.
 *
 * @author Han Sloetjes
 */
public class AnnotationModeCA extends CommandAction {
    private ElanLayoutManager layoutManager;

    /**
     * Creates a new AnnotationModeCA instance
     *
     * @param theVM DOCUMENT ME!
     * @param layoutManager DOCUMENT ME!
     */
    public AnnotationModeCA(ViewerManager2 theVM,
        ElanLayoutManager layoutManager) {
        super(theVM, ELANCommandFactory.ANNOTATION_MODE);
        this.layoutManager = layoutManager;
    }

    /**
     * DOCUMENT ME!
     */
    protected void newCommand() {
        command = ELANCommandFactory.createCommand(vm.getTranscription(),
                ELANCommandFactory.ANNOTATION_MODE);
    }

    /**
     * The receiver of this CommandAction is the layoutManager.
     *
     * @return DOCUMENT ME!
     */
    protected Object getReceiver() {
        return layoutManager;
    }

    /**
     * Returns null, no arguments need to be passed.
     *
     * @return DOCUMENT ME!
     */
    protected Object[] getArguments() {
        return null;
    }
}
