/*
 * File:     CloseCommand.java
 * Project:  MPI Linguistic Application
 * Date:     12 December 2007
 *
 * Copyright (C) 2001-2008  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.commands;

import mpi.eudico.client.annotator.ElanFrame2;

import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;


/**
 * A Command that closes a single Elan frame.
 *
 * @author Han Sloetjes, MPI
 * @version 1.0
  */
public class CloseCommand implements Command {
    private String commandName;

    /**
     * Creates a new CloseCommand instance
     *
     * @param name the name of the command
     */
    public CloseCommand(String name) {
        commandName = name;
    }

    /**
     * <b>Note: </b>it is assumed the types and order of the arguments are
     * correct.
     *
     * @param receiver the Transcription
     * @param arguments the arguments:  <ul><li>null</li> </ul>
     */
    public void execute(Object receiver, Object[] arguments) {
        final TranscriptionImpl transcription = (TranscriptionImpl) receiver;
        final ElanFrame2 frame = (ElanFrame2) ELANCommandFactory.getRootFrame(transcription);

        if (transcription.isChanged()) {
            // the frame should unregister with the FrameManager
            frame.checkSaveAndClose();
        } else {
            frame.doClose(true);
        }
    }

    /**
     * Returns the name of the command.
     *
     * @return the name of the command
     */
    public String getName() {
        return commandName;
    }
}
