/*
 * File:     CommandAction.java
 * Project:  MPI Linguistic Application
 * Date:     12 December 2007
 *
 * Copyright (C) 2001-2008  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.commands;

import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.ElanLocaleListener;
import mpi.eudico.client.annotator.ViewerManager2;

import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;


/**
 * DOCUMENT ME! $Id: CommandAction.java 7402 2006-11-30 08:29:07Z hasloe $
 *
 * @author $Author$
 * @version $Revision$
 */
public abstract class CommandAction extends AbstractAction
    implements ElanLocaleListener {
    /** a prefix for mnemonic keys */
    public static final String MNEMONIC = "MNEMONIC.";

    /** Holds value of property DOCUMENT ME! */
    protected Command command;
    private String commandId;

    /** Holds value of property DOCUMENT ME! */
    protected ViewerManager2 vm;

    /**
     * Creates a new CommandAction instance
     *
     * @param theVM DOCUMENT ME!
     * @param name DOCUMENT ME!
     */
    public CommandAction(ViewerManager2 theVM, String name) {
        super(name);

        vm = theVM;
        commandId = name;

        ElanLocale.addElanLocaleListener(vm.getTranscription(), this);
        updateLocale();
    }

    /**
     * Creates a new CommandAction instance
     *
     * @param theVM DOCUMENT ME!
     * @param name DOCUMENT ME!
     * @param icon DOCUMENT ME!
     */
    public CommandAction(ViewerManager2 theVM, String name, Icon icon) {
        super(name, icon);

        vm = theVM;
        commandId = name;

        ElanLocale.addElanLocaleListener(vm.getTranscription(), this);
        updateLocale();
    }

    /**
     * DOCUMENT ME!
     */
    protected abstract void newCommand();

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    protected Object getReceiver() {
        return null;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    protected Object[] getArguments() {
        return null;
    }

    /**
     * DOCUMENT ME!
     *
     * @param event DOCUMENT ME!
     */
    public void actionPerformed(ActionEvent event) {
        newCommand();

        if (command != null) {
            command.execute(getReceiver(), getArguments());
        }
    }

    // external command sent (e.g. via P2P network)
    public void externalCommand(Object receiver, Object[] args) {
        newCommand();

        if (receiver == null) {
            receiver = getReceiver();
        }

        if (args == null) {
            args = getArguments();
        }

        if (command != null) {
            command.execute(receiver, args);
        }
    }

    /**
     * DOCUMENT ME!
     */
    public void updateLocale() {
        Object newString = null;

        if (commandId != null) {
            newString = "" + ElanLocale.getString(commandId);
        }

        //when there is an icon, set text to empty string (otherwise text appears on a button)
        //also handle the tooltip text
        Object[] obj = getKeys();

        for (int i = 0; i < obj.length; i++) {
            if (obj[i].equals("SmallIcon")) {
                newString = "";
            }
        }

        Object object = getValue(Action.SHORT_DESCRIPTION);

        if ((object != null) && (object.equals("") == false)) {
            putValue(Action.SHORT_DESCRIPTION,
                ElanLocale.getString(commandId + "ToolTip"));
        }

        putValue(Action.NAME, newString);

        String mnemonic = ElanLocale.getString(MNEMONIC + commandId);

        if (mnemonic.length() > 0) {
            try {
                putValue(Action.MNEMONIC_KEY, new Integer(mnemonic.charAt(0)));
            } catch (NumberFormatException nfe) {
                try {
                    putValue(Action.MNEMONIC_KEY, new Integer(mnemonic));
                } catch (NumberFormatException nfe2) {
                    putValue(Action.MNEMONIC_KEY, null);
                }
            }
        }
    }
}
