/*
 * File:     CopyAnnotationTreeCommand.java
 * Project:  MPI Linguistic Application
 * Date:     12 December 2007
 *
 * Copyright (C) 2001-2008  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.commands;

import mpi.eudico.client.annotator.util.AnnotationRecreator;
import mpi.eudico.client.annotator.util.TransferableAnnotationTree;

import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;

import java.awt.Toolkit;

import javax.swing.tree.DefaultMutableTreeNode;


/**
 * A Command to copy an annotation with it's dependent annotations (i.e. a transferable DefaultMutableTreeNode)
 * to the System's Clipboard.
 */
public class CopyAnnotationTreeCommand extends CopyAnnotationCommand {
    /**
     * Creates a new CopyAnnotationTreeCommand instance
     *
     * @param name the name of the command
     */
    public CopyAnnotationTreeCommand(String name) {
        super(name);
    }

    /**
     * <b>Note: </b>it is assumed the types and order of the arguments are
     * correct.
     *
     * @param receiver null
     * @param arguments the arguments:  <ul><li>arg[0] = the (active) annotation
     *        (Annotation)</li></ul>
     */
    public void execute(Object receiver, Object[] arguments) {
        if (arguments[0] instanceof AbstractAnnotation) {
            DefaultMutableTreeNode node = AnnotationRecreator.createTreeForAnnotation((AbstractAnnotation) arguments[0]);
            TransferableAnnotationTree ta = new TransferableAnnotationTree(node);

            if (canAccessSystemClipboard()) {
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ta,
                    ta);
            }
        }
    }
}
