/*
 * File:     CopyTierDlgCommand.java
 * Project:  MPI Linguistic Application
 * Date:     12 December 2007
 *
 * Copyright (C) 2001-2008  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.commands;

import mpi.eudico.client.annotator.ElanLocale;

import mpi.eudico.client.annotator.gui.multistep.MultiStepPane;
import mpi.eudico.client.annotator.gui.multistep.StepPane;

import mpi.eudico.client.annotator.tier.CopyTierStep1;
import mpi.eudico.client.annotator.tier.CopyTierStep2;
import mpi.eudico.client.annotator.tier.CopyTierStep3;

import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

import javax.swing.JDialog;


/**
 * A Command that creates a dialog to copy a Tier.
 *
 * @author Han Sloetjes
 */
public class CopyTierDlgCommand implements Command {
    private String commandName;

    /**
     * Creates a new CopyTierDlgCommand instance
     *
     * @param theName the name of the command
     */
    public CopyTierDlgCommand(String theName) {
        commandName = theName;
    }

    /**
     * Shows a multiple step dialog (wizard) to copy a tier. <b>Note: </b>it is
     * assumed the types and order of the arguments are correct.
     *
     * @param receiver the transcription
     * @param arguments the arguments: <ul><li>arg[0] = </li> </ul>
     */
    public void execute(Object receiver, Object[] arguments) {
        TranscriptionImpl trans = (TranscriptionImpl) receiver;

        MultiStepPane pane = new MultiStepPane(ElanLocale.getResourceBundle());
        pane.putStepProperty("CopyMode", "true");

        StepPane step1 = new CopyTierStep1(pane, trans);
        StepPane step2 = new CopyTierStep2(pane, trans);
        StepPane step3 = new CopyTierStep3(pane, trans);
        pane.addStep(step1);
        pane.addStep(step2);
        pane.addStep(step3);

        JDialog dialog = pane.createDialog(ELANCommandFactory.getRootFrame(
                    trans), ElanLocale.getString("Menu.Tier.CopyTierDialog"),
                true);

        dialog.setVisible(true);
    }

    /**
     * Returns the name of the command
     *
     * @return the name of the command
     */
    public String getName() {
        return commandName;
    }
}
