/*
 * File:     DeleteAnnotationAltCA.java
 * Project:  MPI Linguistic Application
 * Date:     12 December 2007
 *
 * Copyright (C) 2001-2008  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.commands;

import mpi.eudico.client.annotator.ViewerManager2;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;

import javax.swing.Action;
import javax.swing.KeyStroke;


/**
 * An alternative for the Alt-D CommandAction; on (some?) MacOS 10.4
 * systems Alt-D (sometimes) doesn't delete the annotation but invokes
 * some kind of input method window. This is an alternative.
 * Also the Alt-<single-char> combinations interfere with the mnemonics access to
 * the menu's.
 *
 * @author Han Sloetjes, MPI
 */
public class DeleteAnnotationAltCA extends DeleteAnnotationCA {
    /**
     * Constructor.
     *
     * @param viewerManager the viewer manager
     */
    public DeleteAnnotationAltCA(ViewerManager2 viewerManager) {
        super(viewerManager);

        putValue(Action.ACCELERATOR_KEY,
            KeyStroke.getKeyStroke(KeyEvent.VK_D,
                Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() +
                ActionEvent.ALT_MASK));
    }
}
