/*
 * File:     EditTierDlgCommand.java
 * Project:  MPI Linguistic Application
 * Date:     12 December 2007
 *
 * Copyright (C) 2001-2008  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.commands;

import mpi.eudico.client.annotator.ElanLocale;

import mpi.eudico.client.annotator.gui.EditTierDialog;
import mpi.eudico.client.annotator.gui.EditTierDialog2;

import mpi.eudico.server.corpora.clom.Transcription;

import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;

import javax.swing.JFrame;
import javax.swing.JOptionPane;


/**
 * Creates a JDialog for defining, changing or deleting a Tier.
 *
 * @author Han Sloetjes
 */
public class EditTierDlgCommand implements Command {
    private String commandName;

    /**
     * Creates a new EditTierDlgCommand instance
     *
     * @param name DOCUMENT ME!
     */
    public EditTierDlgCommand(String name) {
        commandName = name;
    }

    /**
     * <b>Note: </b>it is assumed the types and order of the arguments are
     * correct.
     *
     * @param receiver the Transcription
     * @param arguments the arguments:  <ul><li>arg[0] = the edit mode, ADD,
     *        CHANGE or DELETE (Integer)</li> <li>arg[1] = the tier to
     *        initialise the dialog with (TierImpl)</li> </ul>
     */
    public void execute(Object receiver, Object[] arguments) {
        Transcription transcription = (Transcription) receiver;
        JFrame frame = ELANCommandFactory.getRootFrame(transcription);
        Integer mode = (Integer) arguments[0];
        TierImpl tier = null;

        if (arguments[1] instanceof TierImpl) {
            tier = (TierImpl) arguments[1];
        }

        if (mode.intValue() == EditTierDialog.ADD) {
            // don't show the add tier dialog when no linguistic types have been defined
            if (transcription.getLinguisticTypes().size() == 0) {
                StringBuffer buf = new StringBuffer();
                buf.append(ElanLocale.getString(
                        "EditTierDialog.Message.NoTypes"));
                buf.append("\n");
                buf.append(ElanLocale.getString(
                        "EditTierDialog.Message.CreateType"));
                JOptionPane.showMessageDialog(frame, buf.toString(),
                    ElanLocale.getString("Message.Error"),
                    JOptionPane.ERROR_MESSAGE);

                return;
            }
        }

        new EditTierDialog2(frame, true, transcription, mode.intValue(), tier).setVisible(true);
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getName() {
        return commandName;
    }
}
