/*
 * File:     ExportMediaCA.java
 * Project:  MPI Linguistic Application
 * Date:     12 December 2007
 *
 * Copyright (C) 2001-2008  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.commands;

import mpi.eudico.client.annotator.SelectionListener;
import mpi.eudico.client.annotator.ViewerManager2;

import java.io.IOException;


/**
 *
 */
public class ExportMediaCA extends CommandAction implements SelectionListener {
    private boolean available;

    /**
      * Creates a new ExportMediaCA instance
      *
      * @param viewerManager DOCUMENT ME!
      */
    public ExportMediaCA(ViewerManager2 viewerManager) {
        super(viewerManager, ELANCommandFactory.EXPORT_MEDIA);

        try {
            // check if possible, for the time being only looks for one tool
            Runtime.getRuntime().exec("M2-edit-cl");
            System.out.println("Found executable version of M2-edit-cl");
            available = true;
        } catch (IOException e) {
            //e.printStackTrace();
            // exception if exec was impossible
            available = false;
            System.out.println("No media export functionality available");
        }

        viewerManager.connectListener(this);

        setEnabled(available);
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public boolean isAvailable() {
        return available;
    }

    /**
     * DOCUMENT ME!
     */
    protected void newCommand() {
        command = ELANCommandFactory.createCommand(vm.getTranscription(),
                ELANCommandFactory.EXPORT_MEDIA);
    }

    /**
     * There's no logical receiver for this CommandAction.
     *
     * @return DOCUMENT ME!
     */
    protected Object getReceiver() {
        return null;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    protected Object[] getArguments() {
        return new Object[] { vm };
    }

    // only activate menu item when selection is made
    // if the user may define a time interval in a dialog this is obsolete
    public void updateSelection() {
        if (available) {
            if (vm.getSelection().getEndTime() > vm.getSelection().getBeginTime()) {
                setEnabled(true);
            } else {
                setEnabled(false);
            }
        }
    }
}
