/*
 * File:     FontBrowserCA.java
 * Project:  MPI Linguistic Application
 * Date:     12 December 2007
 *
 * Copyright (C) 2001-2008  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.commands;

import mpi.eudico.client.annotator.ViewerManager2;

import mpi.util.FontBrowser.FontGui;

import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

import javax.swing.WindowConstants;


/**
 * An action to open the MPI font browser.!
 *
 * @author Han Sloetjes
 * @version 1.0
 */
public class FontBrowserCA extends CommandAction {
    private FontGui browser = null;

    /**
     * Creates a new FontBrowserCA instance
     *
     * @param theVM the viewer manager
     */
    public FontBrowserCA(ViewerManager2 theVM) {
        super(theVM, ELANCommandFactory.FONT_BROWSER);
    }

    /**
     * Creates a new command.
     */
    protected void newCommand() {
        command = ELANCommandFactory.createCommand(vm.getTranscription(),
                ELANCommandFactory.FONT_BROWSER);
    }

    /**
     * @see mpi.eudico.client.annotator.commands.CommandAction#getArguments()
     */
    protected Object[] getArguments() {
        return new Object[] { browser };
    }

    /**
     * @see mpi.eudico.client.annotator.commands.CommandAction#actionPerformed(java.awt.event.ActionEvent)
     */
    public void actionPerformed(ActionEvent event) {
        if (browser == null) {
            browser = new FontGui();

            // remove the default window listeners, one of them calls System.exit
            WindowListener[] wl = browser.getWindowListeners();

            for (int i = 0; i < wl.length; i++) {
                browser.removeWindowListener(wl[i]);
            }

            browser.setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);

            // add a window listener that nullifies the browser member when
            // the font browser window is closed
            browser.addWindowListener(new WindowAdapter() {
                    public void windowClosed(WindowEvent e) {
                        FontBrowserCA.this.browser.removeWindowListener(this); //??
                        FontBrowserCA.this.browser = null;
                    }
                });

            super.actionPerformed(event);
        }
    }
}
