/*
 * File:     FontBrowserCommand.java
 * Project:  MPI Linguistic Application
 * Date:     12 December 2007
 *
 * Copyright (C) 2001-2008  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.commands;

import mpi.util.FontBrowser.FontGui;

import java.awt.Frame;
import java.awt.event.WindowListener;

import javax.swing.WindowConstants;


/**
 * Makes the font browser window visible.
 *
 * @author Han SLoetjes
 * @version 1.0
 */
public class FontBrowserCommand implements Command {
    private String commandName;

    /**
     * Creates a new font browser command.
     *
     * @param name the name of the command
     */
    public FontBrowserCommand(String name) {
        commandName = name;
    }

    /**
     * Sets the Font Browser visible.
     *
     * @param receiver null
     * @param arguments the Font Browser
     */
    public void execute(Object receiver, Object[] arguments) {
        if ((arguments != null) && (arguments.length >= 1)) {
            if (arguments[0] instanceof Frame) {
                ((Frame) arguments[0]).setVisible(true);
            }
        }
    }

    /**
     * Returns the name of the command
     *
     * @return the name
     */
    public String getName() {
        return commandName;
    }
}
