/*
 * File:     KioskModeCA.java
 * Project:  MPI Linguistic Application
 * Date:     12 December 2007
 *
 * Copyright (C) 2001-2008  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.commands;

import mpi.eudico.client.annotator.ViewerManager2;

import java.awt.event.ActionEvent;


/**
 * A class to switch to and from Kisok Mode. In this mode the player will play
 * the complete media file in a loop, all interaction is disabled.
 *
 * @author Han Sloetjes, MPI
 */
public class KioskModeCA extends CommandAction {
    private boolean selected = false;

    /**
     * Creates a new KioskMode command action.
     *
     * @param viewerManager the viewer manager
     */
    public KioskModeCA(ViewerManager2 viewerManager) {
        super(viewerManager, ELANCommandFactory.KIOSK_MODE);
    }

    /**
     * Creates a new KioskMode command.
     */
    protected void newCommand() {
        command = ELANCommandFactory.createCommand(vm.getTranscription(),
                ELANCommandFactory.KIOSK_MODE);
    }

    /**
     * Object array of size 1: Boolean switching kiosk mode on or off.
     *
     * @return the arguments
     */
    protected Object[] getArguments() {
        return new Object[] { new Boolean(selected) };
    }

    /**
     * Returns the viewermanager as the central object giving access to all
     * necessary components.
     *
     * @return the viewermanager
     */
    protected Object getReceiver() {
        return vm;
    }

    /**
     * Inverses the selected value and calls the super implementation.
     *
     * @param event the action event
     */
    public void actionPerformed(ActionEvent event) {
        selected = !selected;

        super.actionPerformed(event);
    }
}
