/*
 * File:     ModifyGraphicAnnotationCommand.java
 * Project:  MPI Linguistic Application
 * Date:     12 December 2007
 *
 * Copyright (C) 2001-2008  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.commands;

import mpi.eudico.server.corpora.clomimpl.abstr.SVGAlignableAnnotation;

import java.awt.Shape;


/**
 * A command for modifying a graphical annotation.
 *
 * @author Han Sloetjes
 */
public class ModifyGraphicAnnotationCommand implements UndoableCommand {
    private String commandName;
    private SVGAlignableAnnotation annotation;
    private Shape oldShape;
    private Shape newShape;

    /**
     * Creates a new ModifyGraphicAnnotationCommand instance
     *
     * @param name the name of the command
     */
    public ModifyGraphicAnnotationCommand(String name) {
        commandName = name;
    }

    /**
     * Undo the changes made by this command.
     */
    public void undo() {
        if (annotation != null) {
            annotation.setShape(oldShape);
        }
    }

    /**
     * Redo the changes made by this command.
     */
    public void redo() {
        if (annotation != null) {
            annotation.setShape(newShape);
        }
    }

    /**
     * <b>Note: </b>it is assumed the types and order of the arguments are
     * correct.
     *
     * @param receiver the active Annotation
     * @param arguments the arguments:  <ul><li>arg[0] = the new value of the
     *        graphical annotation (Shape)</li> </ul>
     */
    public void execute(Object receiver, Object[] arguments) {
        annotation = (SVGAlignableAnnotation) receiver;
        oldShape = annotation.getShape();
        newShape = (Shape) arguments[0];
        annotation.setShape(newShape);
    }

    /**
     * Returns the name of this command.
     *
     * @return the name of this command
     */
    public String getName() {
        return commandName;
    }
}
