/*
 * File:     PlayPauseCA.java
 * Project:  MPI Linguistic Application
 * Date:     12 December 2007
 *
 * Copyright (C) 2001-2008  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.commands;

import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.ViewerManager2;

import mpi.eudico.client.mediacontrol.ControllerEvent;
import mpi.eudico.client.mediacontrol.ControllerListener;
import mpi.eudico.client.mediacontrol.StartEvent;
import mpi.eudico.client.mediacontrol.StopEvent;

//import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;

import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;


/**
 * DOCUMENT ME! $Id: PlayPauseCA.java,v 1.1.1.1 2004/03/25 16:23:16 wouthuij
 * Exp $
 *
 * @author $Author$
 * @version $Revision$
 */
public class PlayPauseCA extends CommandAction implements ControllerListener {
    private Icon playIcon;
    private Icon pauseIcon;

    /**
     * Creates a new PlayPauseCA instance
     *
     * @param theVM DOCUMENT ME!
     */
    public PlayPauseCA(ViewerManager2 theVM) {
        //super();
        super(theVM, ELANCommandFactory.PLAY_PAUSE);

        // ask ViewerManager to connect to player
        vm.connectListener(this);

        playIcon = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/PlayButton.gif"));
        pauseIcon = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/PauseButton.gif"));
        putValue(SMALL_ICON, playIcon);

        // Command-Space on the Mac is reserved for input method switching
        putValue(Action.ACCELERATOR_KEY,
            KeyStroke.getKeyStroke(KeyEvent.VK_SPACE, 
        /*Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()*/
        ActionEvent.CTRL_MASK));
        putValue(SHORT_DESCRIPTION,
            ElanLocale.getString(ELANCommandFactory.PLAY_PAUSE + "ToolTip"));
        putValue(Action.NAME, "");
    }

    /**
     * DOCUMENT ME!
     */
    protected void newCommand() {
        command = ELANCommandFactory.createCommand(vm.getTranscription(),
                ELANCommandFactory.PLAY_PAUSE);
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    protected Object getReceiver() {
        return vm.getMasterMediaPlayer();
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    protected Object[] getArguments() {
        Object[] args = new Object[1];
        args[0] = vm.getMediaPlayerController();

        return args;
    }

    /**
     * DOCUMENT ME!
     *
     * @param event DOCUMENT ME!
     */
    public void controllerUpdate(ControllerEvent event) {
        if (event instanceof StopEvent) {
            setPlayPauseButton(true);
        }

        if (event instanceof StartEvent) {
            setPlayPauseButton(false);
        }
    }

    private void setPlayPauseButton(boolean play) {
        if (play) {
            putValue(SMALL_ICON, playIcon);
        } else {
            putValue(SMALL_ICON, pauseIcon);
        }
    }
}
