/*
 * File:     PlayPauseCommand.java
 * Project:  MPI Linguistic Application
 * Date:     12 December 2007
 *
 * Copyright (C) 2001-2008  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.commands;

import mpi.eudico.client.annotator.ElanMediaPlayerController;

import mpi.eudico.client.annotator.player.ElanMediaPlayer;
import mpi.eudico.client.annotator.player.NativeMediaPlayerWindowsDS;


/**
 * DOCUMENT ME!
 * $Id: PlayPauseCommand.java 8514 2007-04-05 13:17:36Z hasloe $
 * @author $Author$
 * @version $Revision$
 */
public class PlayPauseCommand implements Command {
    private String commandName;
    private ElanMediaPlayer player;
    private ElanMediaPlayerController mediaPlayerController;

    /**
     * Creates a new PlayPauseCommand instance
     *
     * @param theName DOCUMENT ME!
     */
    public PlayPauseCommand(String theName) {
        commandName = theName;
    }

    /**
     * DOCUMENT ME!
     *
     * @param receiver DOCUMENT ME!
     * @param arguments DOCUMENT ME!
     */
    public void execute(Object receiver, Object[] arguments) {
        // receiver is master ElanMediaPlayer
        // arguments[0] is ElanMediaPlayerController
        player = (ElanMediaPlayer) receiver;
        mediaPlayerController = (ElanMediaPlayerController) arguments[0];

        if (player == null) {
            return;
        }

        boolean playSel = mediaPlayerController.isPlaySelectionMode();
        mediaPlayerController.setPlaySelectionMode(false);
        mediaPlayerController.stopLoop();

        if (player.isPlaying() == true) {
            player.stop();

            if (playSel) {
                if (player instanceof NativeMediaPlayerWindowsDS) {
                    // workaround
                    long t = player.getMediaTime();
                    player.setMediaTime(mediaPlayerController.getSelectionEndTime());
                    player.setStopTime(player.getMediaDuration()); //??
                    player.setMediaTime(t);
                } else {
                    player.setStopTime(player.getMediaDuration());
                }
            }
        } else {
            player.start();
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getName() {
        return commandName;
    }
}
