/*
 * File:     PlaySelectionCA.java
 * Project:  MPI Linguistic Application
 * Date:     12 December 2007
 *
 * Copyright (C) 2001-2008  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.commands;

import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.SelectionListener;
import mpi.eudico.client.annotator.ViewerManager2;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;

import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;


/**
 * DOCUMENT ME!
 * $Id: PlaySelectionCA.java 7469 2006-12-05 08:16:39Z hasloe $
 * @author $Author$
 * @version $Revision$
 */
public class PlaySelectionCA extends CommandAction implements SelectionListener {
    private Icon icon;

    /**
     * Creates a new PlaySelectionCA instance
     *
     * @param theVM DOCUMENT ME!
     */
    public PlaySelectionCA(ViewerManager2 theVM) {
        //super();
        super(theVM, ELANCommandFactory.PLAY_SELECTION);

        icon = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/PlaySelectionButton.gif"));
        putValue(SMALL_ICON, icon);
        putValue(Action.ACCELERATOR_KEY,
            KeyStroke.getKeyStroke(KeyEvent.VK_SPACE, ActionEvent.SHIFT_MASK));
        putValue(SHORT_DESCRIPTION,
            ElanLocale.getString(ELANCommandFactory.PLAY_SELECTION + "ToolTip"));
        putValue(Action.NAME, "");
        vm.connectListener(this);
    }

    /**
     * Play around selection and play selection use the same command; play
     * selection passes 0 as offset.
     */
    protected void newCommand() {
        command = ELANCommandFactory.createCommand(vm.getTranscription(),
                ELANCommandFactory.PLAY_SELECTION);
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    protected Object getReceiver() {
        return vm.getMasterMediaPlayer();
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    protected Object[] getArguments() {
        Object[] args = new Object[3];
        args[0] = vm.getSelection();
        args[1] = vm.getMediaPlayerController();
        args[2] = new Integer(0);

        return args;
    }

    /**
     * If the selection changes while playing a selection stop playing the (old)
     * selection. Stop the player as well??
     * @see mpi.eudico.client.annotator.SelectionListener#updateSelection()
     */
    public void updateSelection() {
        if (vm.getMasterMediaPlayer().isPlaying()) {
            if (vm.getMediaPlayerController().isPlaySelectionMode()) {
                vm.getMediaPlayerController().setPlaySelectionMode(false);
                vm.getMasterMediaPlayer().stop();
                vm.getMasterMediaPlayer().setStopTime(vm.getMasterMediaPlayer()
                                                        .getMediaDuration());
            }
        }
    }
}
