/*
 * File:     PlaySelectionCommand.java
 * Project:  MPI Linguistic Application
 * Date:     12 December 2007
 *
 * Copyright (C) 2001-2008  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.commands;

import mpi.eudico.client.annotator.ElanMediaPlayerController;
import mpi.eudico.client.annotator.Selection;

import mpi.eudico.client.annotator.player.ElanMediaPlayer;
import mpi.eudico.client.annotator.player.NativeMediaPlayerWindowsDS;
import mpi.eudico.client.annotator.player.QTMediaPlayer;


/**
 * DOCUMENT ME!
 * $Id: PlaySelectionCommand.java 8514 2007-04-05 13:17:36Z hasloe $
 * @author $Author$
 * @version $Revision$
 */
public class PlaySelectionCommand implements Command {
    private String commandName;
    private ElanMediaPlayer player;
    private Selection s;
    private ElanMediaPlayerController mediaPlayerController;
    private long beginTime;
    private long endTime;

    /**
     * Creates a new PlaySelectionCommand instance
     *
     * @param theName DOCUMENT ME!
     */
    public PlaySelectionCommand(String theName) {
        commandName = theName;
    }

    /**
     * DOCUMENT ME!
     *
     * @param receiver DOCUMENT ME!
     * @param arguments DOCUMENT ME!
     */
    public void execute(Object receiver, Object[] arguments) {
        // receiver is master ElanMediaPlayer
        // arguments[0] is Selection
        // arguments[1] is ElanMediaPlayerController
        // arguments[2] is the play around selection value
        player = (ElanMediaPlayer) receiver;
        s = (Selection) arguments[0];
        mediaPlayerController = (ElanMediaPlayerController) arguments[1];

        int playAroundSelectionValue = ((Integer) arguments[2]).intValue();

        if (player == null) {
            return;
        }

        //stop if a selection is being played
        if (player.isPlaying()) {
            //mediaPlayerController.setPlaySelectionMode(false);
            player.stop();

            //mediaPlayerController.setLoopMode(false);
            mediaPlayerController.stopLoop();
            mediaPlayerController.setPlaySelectionMode(false);

            // if playing a selection has been stopped before the end of the selection this 
            // makes the player jump to the end of the file when the old stoptime is reached
            // with Windows media framework
            if (player instanceof NativeMediaPlayerWindowsDS) {
                // workaround
                long t = player.getMediaTime();
                player.setMediaTime(mediaPlayerController.getSelectionEndTime());
                player.setStopTime(player.getMediaDuration()); //??
                player.setMediaTime(t);
            } else {
                player.setStopTime(player.getMediaDuration());
            }

            return;
        }

        long mediaTime = player.getMediaTime();

        beginTime = s.getBeginTime();
        endTime = s.getEndTime();

        //if there is no selection
        if (beginTime == endTime) {
            return;
        }

        //apply the play around selection value
        if (playAroundSelectionValue > 0) {
            beginTime -= playAroundSelectionValue;

            if (beginTime < 0) {
                beginTime = 0;
            }

            endTime += playAroundSelectionValue;

            if (endTime > player.getMediaDuration()) {
                endTime = player.getMediaDuration();
            }
        }

        //if not playing, start playing
        if ((player.isPlaying() == false) && (mediaTime >= beginTime) &&
                (mediaTime < endTime)) {
            mediaPlayerController.setPlaySelectionMode(true);
            playInterval(mediaTime, endTime);
            doStartLoop();

            return;
        }

        if (mediaPlayerController.getLoopMode() == true) {
            mediaPlayerController.setPlaySelectionMode(true);
            doStartLoop();
        } else {
            mediaPlayerController.setPlaySelectionMode(true);
            playInterval(beginTime, endTime);
        }
    }

    private void playInterval(long begin, long end) {
        player.playInterval(begin, end);
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getName() {
        return commandName;
    }

    /**
     * DOCUMENT ME!
     */
    public void doStartLoop() {
        //LoopThread loopthread = new LoopThread();
        //loopthread.start();
        mediaPlayerController.startLoop(beginTime, endTime);
    }

    /**
     * Starts a new playing thread when loopmode is true
     */
    private class LoopThread extends Thread {
        /**
         * DOCUMENT ME!
         */
        public void run() {
            while (mediaPlayerController.isPlaySelectionMode() &&
                    (mediaPlayerController.getLoopMode() == true)) {
                if (!player.isPlaying()) {
                    playInterval(beginTime, endTime);
                }

                while (player.isPlaying() == true) {
                    try {
                        Thread.sleep(10);
                    } catch (Exception ex) {
                    }
                }

                try {
                    Thread.sleep(mediaPlayerController.getUserTimeBetweenLoops());
                } catch (Exception ex) {
                }
            }
        }
    }

    //end of LoopThread
}
