/*
 * File:     SetPlayAroundSelectionCommand.java
 * Project:  MPI Linguistic Application
 * Date:     12 December 2007
 *
 * Copyright (C) 2001-2008  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.commands;


/**
 * Sets the value for playing around a selection.
 *
 * @author Han Sloetjes
 */
public class SetPlayAroundSelectionCommand implements UndoableCommand {
    private String commandName;
    private int oldValue;
    private int newValue;
    private PlayAroundSelectionCA action;

    /**
     * Creates a new SetPlayAroundSelectionCommand instance
     *
     * @param theName DOCUMENT ME!
     */
    public SetPlayAroundSelectionCommand(String theName) {
        commandName = theName;
    }

    /**
     * DOCUMENT ME!
     */
    public void undo() {
        if (action != null) {
            action.setPlayAroundSelectionValue(oldValue);
        }
    }

    /**
     * DOCUMENT ME!
     */
    public void redo() {
        if (action != null) {
            action.setPlayAroundSelectionValue(newValue);
        }
    }

    /**
     * <b>Note: </b>it is assumed the types and order of the arguments are
     * correct.
     *
     * @param receiver the PlaySelectionCA
     * @param arguments the arguments:  <ul><li>arg[0] = the value for playing
     *        around the selection (Integer)</li> </ul>
     */
    public void execute(Object receiver, Object[] arguments) {
        action = (PlayAroundSelectionCA) receiver;
        oldValue = action.getPlayAroundSelectionValue();
        newValue = ((Integer) arguments[0]).intValue();
        action.setPlayAroundSelectionValue(newValue);
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getName() {
        return commandName;
    }
}
