/*
 * File:     SetPlayAroundSelectionDlgCommand.java
 * Project:  MPI Linguistic Application
 * Date:     12 December 2007
 *
 * Copyright (C) 2001-2008  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.commands;

import mpi.eudico.client.annotator.ViewerManager2;

import mpi.eudico.client.annotator.gui.PlayAroundSelectionDialog;

import java.awt.Frame;


/**
 * Brings up a JDialog for setting the play around selection value.
 *
 * @author Han Sloetjes
 */
public class SetPlayAroundSelectionDlgCommand implements Command {
    private String commandName;

    /**
     * Creates a new SetPlayAroundSelectionDlgCommand instance
     *
     * @param theName DOCUMENT ME!
     */
    public SetPlayAroundSelectionDlgCommand(String theName) {
        commandName = theName;
    }

    /**
     * DOCUMENT ME!
     *
     * @param receiver DOCUMENT ME!
     * @param arguments DOCUMENT ME!
     */
    public void execute(Object receiver, Object[] arguments) {
        PlayAroundSelectionCA action = (PlayAroundSelectionCA) receiver;
        ViewerManager2 vm = (ViewerManager2) arguments[0];
        Frame owner = ELANCommandFactory.getRootFrame(vm.getTranscription());
        new PlayAroundSelectionDialog(owner, action, vm).setVisible(true);
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getName() {
        return commandName;
    }
}
