/*
 * File:     ShiftAllAnnotationsDlgCommand.java
 * Project:  MPI Linguistic Application
 * Date:     12 December 2007
 *
 * Copyright (C) 2001-2008  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.commands;

import mpi.eudico.client.annotator.gui.ShiftAllDialog;

import mpi.eudico.server.corpora.clom.Transcription;


/**
 * A Command that brings up a JDialog where the user can enter a shift value
 * for all annotations (i.e. all time slots).
 *
 * @author Han Sloetjes
 */
public class ShiftAllAnnotationsDlgCommand implements Command {
    private String commandName;

    /**
     * Creates a new shift all command.
     *
     * @param name the name of the command
     */
    public ShiftAllAnnotationsDlgCommand(String name) {
        commandName = name;
    }

    /**
     * Creates the dialog.
     *
     * @param receiver the transcription
     * @param arguments null
     */
    public void execute(Object receiver, Object[] arguments) {
        Transcription transcription = (Transcription) receiver;
        new ShiftAllDialog(transcription).setVisible(true);
    }

    /**
     * Returns the name of the command
     *
     * @return the name
     */
    public String getName() {
        return commandName;
    }
}
