/*
 * File:     ShortcutsCA.java
 * Project:  MPI Linguistic Application
 * Date:     12 December 2007
 *
 * Copyright (C) 2001-2008  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.commands;

import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.ViewerManager2;

import mpi.eudico.client.annotator.export.ShortCutPrinter;

import mpi.eudico.client.annotator.gui.ClosableFrame;

import mpi.eudico.client.util.SubHeaderTableCellRenderer;
import mpi.eudico.client.util.TableSubHeaderObject;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;


/**
 *
 */
public class ShortcutsCA extends CommandAction {
    private JFrame shortcutsFrame;
    private JTable tableShortcuts;
    private JButton printButton;

    /**
     * Creates a new ShortcutsCA instance
     *
     * @param theVM DOCUMENT ME!
     */
    public ShortcutsCA(ViewerManager2 theVM) {
        super(theVM, ELANCommandFactory.SHORTCUTS);
    }

    /**
     * DOCUMENT ME!
     */
    protected void newCommand() {
        command = ELANCommandFactory.createCommand(vm.getTranscription(),
                ELANCommandFactory.SHORTCUTS);
    }

    /**
     *
     */
    protected Object getReceiver() {
        return null;
    }

    /**
     *
     */
    protected Object[] getArguments() {
        Object[] args = new Object[1];
        args[0] = getShortcutsFrame();

        return args;
    }

    private JFrame getShortcutsFrame() {
        if (shortcutsFrame == null) {
            createShortcutsFrame();
        }

        return shortcutsFrame;
    }

    private void createShortcutsFrame() {
        shortcutsFrame = new ClosableFrame("Shortcuts");

        Object[][] objRowData = ELANCommandFactory.getShortCutText(vm.getTranscription());
        String[] objColumnNames = { "", "" };

        tableShortcuts = new JTable(objRowData, objColumnNames);
        tableShortcuts.setBackground(Constants.DEFAULTBACKGROUNDCOLOR);
        tableShortcuts.setPreferredScrollableViewportSize(new Dimension(500, 600));
        tableShortcuts.setShowVerticalLines(false);
        tableShortcuts.getTableHeader().setReorderingAllowed(false);
        tableShortcuts.setEnabled(false);

        tableShortcuts.getColumnModel().getColumn(0).setPreferredWidth(200);
        tableShortcuts.getColumnModel().getColumn(1).setPreferredWidth(300);

        tableShortcuts.setDefaultRenderer(Object.class,
            new SubHeaderTableCellRenderer());

        for (int i = 0; i < tableShortcuts.getRowCount(); i++) {
            if (tableShortcuts.getValueAt(i, 0) instanceof TableSubHeaderObject) {
                tableShortcuts.setRowHeight(i, tableShortcuts.getRowHeight() +
                    6);
            }
        }

        JScrollPane listScrollPane = new JScrollPane(tableShortcuts);

        shortcutsFrame.getContentPane().setLayout(new GridBagLayout());

        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(2, 2, 4, 2);
        gbc.fill = GridBagConstraints.BOTH;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        shortcutsFrame.getContentPane().add(listScrollPane, gbc);

        printButton = new JButton();
        printButton.addActionListener(this);
        gbc.gridy = 1;
        gbc.weightx = 0;
        gbc.weighty = 0;
        gbc.fill = GridBagConstraints.NONE;
        gbc.anchor = GridBagConstraints.CENTER;
        shortcutsFrame.getContentPane().add(printButton, gbc);

        updateLocale();

        shortcutsFrame.pack();
    }

    /**
     * DOCUMENT ME!
     */
    public void updateLocale() {
        super.updateLocale();

        if (tableShortcuts != null) {
            tableShortcuts.getColumnModel().getColumn(0).setHeaderValue(ElanLocale.getString(
                    "Frame.ShortcutFrame.ColumnShortcut"));
            tableShortcuts.getColumnModel().getColumn(1).setHeaderValue(ElanLocale.getString(
                    "Frame.ShortcutFrame.ColumnDescription"));
            printButton.setText(ElanLocale.getString("Menu.File.Print"));

            Object[][] objRowData = ELANCommandFactory.getShortCutText(vm.getTranscription());

            for (int i = 0; i < objRowData.length; i++) {
                tableShortcuts.setValueAt(objRowData[i][1], i, 1);
            }

            shortcutsFrame.setTitle(ElanLocale.getString(
                    "Menu.View.ShortcutsDialog"));
            shortcutsFrame.repaint(); //if tableShortcuts != null, then shortcutsFrame != null too
        }
    }

    /**
     * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
     */
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == printButton) {
            new ShortCutPrinter(tableShortcuts).startPrint();
        } else {
            super.actionPerformed(event);
        }
    }
}
